/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.mavengem;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jruby.embed.IsolatedScriptingContainer;
import org.jruby.embed.ScriptingContainer;
import org.sonatype.nexus.ruby.DefaultRubygemsGateway;
import org.sonatype.nexus.ruby.RubygemsGateway;
import org.torquebox.mojo.mavengem.Rubygems;

public class RubygemsFactory {
    private static RubygemsGateway gateway = new DefaultRubygemsGateway((ScriptingContainer)new IsolatedScriptingContainer());
    private static Map<URL, Rubygems> facades = new HashMap<URL, Rubygems>();
    static URL NO_MIRROR;
    public static File DEFAULT_CACHEDIR;
    public static final String MAVENGEM_MIRROR = "mavengem.mirror";
    public static final String MAVENGEM_CACHEDIR = "mavengem.cachedir";
    final File cacheDir;
    final Map<URL, URL> mirrors;
    final URL catchAllMirror;
    static RubygemsFactory factory;

    public static synchronized RubygemsFactory defaultFactory() throws MalformedURLException {
        if (factory == null) {
            factory = new RubygemsFactory(null, null, null, false);
        }
        return factory;
    }

    public RubygemsFactory() throws MalformedURLException {
        this(DEFAULT_CACHEDIR, NO_MIRROR, null);
    }

    public RubygemsFactory(URL mirror) throws MalformedURLException {
        this(DEFAULT_CACHEDIR, mirror, null);
    }

    public RubygemsFactory(Map<URL, URL> mirrors) throws MalformedURLException {
        this(DEFAULT_CACHEDIR, NO_MIRROR, mirrors);
    }

    public RubygemsFactory(File cacheDir) throws MalformedURLException {
        this(cacheDir, NO_MIRROR, null);
    }

    public RubygemsFactory(File cacheDir, URL mirror) throws MalformedURLException {
        this(cacheDir, mirror, null);
    }

    public RubygemsFactory(File cacheDir, Map<URL, URL> mirrors) throws MalformedURLException {
        this(cacheDir, NO_MIRROR, mirrors);
    }

    private RubygemsFactory(File cacheDir, URL mirror, Map<URL, URL> mirrors) throws MalformedURLException {
        this(cacheDir, mirror, mirrors, true);
    }

    private RubygemsFactory(File cacheDir, URL mirror, Map<URL, URL> mirrors, boolean check) throws MalformedURLException {
        if (check) {
            if (cacheDir == null) {
                throw new IllegalArgumentException("cache directory can not be null");
            }
            if (mirror == null) {
                throw new IllegalArgumentException("mirror can not be null");
            }
        }
        this.catchAllMirror = mirror != null ? mirror : (System.getProperty(MAVENGEM_MIRROR) != null ? new URL(System.getProperty(MAVENGEM_MIRROR)) : NO_MIRROR);
        HashMap<URL, URL> hashMap = this.mirrors = mirrors == null ? null : new HashMap<URL, URL>(mirrors);
        this.cacheDir = cacheDir != null ? cacheDir : (System.getProperty(MAVENGEM_CACHEDIR) != null ? new File(System.getProperty(MAVENGEM_CACHEDIR)) : DEFAULT_CACHEDIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rubygems getOrCreate(URL url) throws MalformedURLException {
        if (this.catchAllMirror != NO_MIRROR) {
            url = this.catchAllMirror;
        } else if (this.mirrors != null && this.mirrors.containsKey(url)) {
            url = this.mirrors.get(url);
        }
        Map<URL, Rubygems> map = facades;
        synchronized (map) {
            Rubygems result = facades.get(url);
            if (result == null) {
                result = new Rubygems(url, this.cacheDir);
                facades.put(url, result);
            }
            return result;
        }
    }

    static {
        try {
            NO_MIRROR = new URL("http://example.com/no_mirror");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("can not happen", e);
        }
        DEFAULT_CACHEDIR = new File(System.getProperty("user.home"), ".mavengem");
    }
}

