/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.mavengem.wagon;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.resource.Resource;
import org.torquebox.mojo.mavengem.MavenGemURLConnection;
import org.torquebox.mojo.mavengem.RubygemsFactory;

public class MavenGemWagon
extends StreamWagon {
    public static final String MAVEN_GEM_PREFIX = "mavengem:";
    private Proxy proxy = Proxy.NO_PROXY;
    private RubygemsFactory _factory_;
    private File cachedir;
    private String mirror;

    private void warn(String msg) {
        System.err.println("WARNING: " + msg);
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        try {
            if (this.proxy != Proxy.NO_PROXY) {
                this.warn("proxy support is not implemented - ignoring proxy settings");
            }
            URLConnection urlConnection = this.newConnection(resource.getName());
            InputStream is = urlConnection.getInputStream();
            inputData.setInputStream(is);
            resource.setLastModified(urlConnection.getLastModified());
            resource.setContentLength((long)urlConnection.getContentLength());
        }
        catch (MalformedURLException e) {
            throw new TransferFailedException("Invalid repository URL: " + e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceDoesNotExistException("Unable to locate resource in repository", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    private RubygemsFactory rubygemsFactory() throws MalformedURLException {
        if (this._factory_ == null) {
            if (this.cachedir == null) {
                this.cachedir = RubygemsFactory.DEFAULT_CACHEDIR;
            }
            this._factory_ = this.mirror != null ? new RubygemsFactory(this.cachedir, this.withAuthentication(this.mirror)) : new RubygemsFactory(this.cachedir);
        }
        return this._factory_;
    }

    public URLConnection newConnection(String resourceName) throws MalformedURLException {
        return new MavenGemURLConnection(this.rubygemsFactory(), this.getRepositoryURL(), "/" + resourceName);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            this.newConnection(resourceName).connect();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (MalformedURLException e) {
            throw new TransferFailedException("Invalid repository URL: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new RuntimeException("only download is provided");
    }

    public void closeConnection() throws ConnectionException {
    }

    private URL withAuthentication(String url) throws MalformedURLException {
        if (this.authenticationInfo != null && this.authenticationInfo.getUserName() != null) {
            String credentials = this.authenticationInfo.getUserName() + ":" + this.authenticationInfo.getPassword();
            url = url.replaceFirst("^(https?://)(.*)$", "$1" + credentials + "@$2");
        }
        return new URL(url);
    }

    private URL getRepositoryURL() throws MalformedURLException {
        String url = this.getRepository().getUrl().substring(MAVEN_GEM_PREFIX.length());
        return this.withAuthentication(url);
    }

    private Proxy getProxy(ProxyInfo proxyInfo) {
        return new Proxy(this.getProxyType(proxyInfo), this.getSocketAddress(proxyInfo));
    }

    private Proxy.Type getProxyType(ProxyInfo proxyInfo) {
        if ("SOCKS4".equals(proxyInfo.getType()) || "SOCKS_5".equals(proxyInfo.getType())) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.HTTP;
    }

    private SocketAddress getSocketAddress(ProxyInfo proxyInfo) {
        return InetSocketAddress.createUnresolved(proxyInfo.getHost(), proxyInfo.getPort());
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        try {
            ProxyInfo proxyInfo = this.getProxyInfo(this.getRepositoryURL().getProtocol(), this.getRepository().getHost());
            if (proxyInfo != null) {
                this.proxy = this.getProxy(proxyInfo);
            }
        }
        catch (MalformedURLException e) {
            throw new ConnectionException("cannot create repository url", (Throwable)e);
        }
    }
}

