/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

import org.torquebox.mojo.rubygems.FileType;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.RubygemsFileFactory;

public class BaseGemFile
extends RubygemsFile {
    private final String filename;
    private final String version;
    private final String platform;

    public static String toFilename(String name, String version, String platform) {
        StringBuilder filename = new StringBuilder(name);
        if (version != null) {
            filename.append("-").append(version);
            if (platform != null && !"ruby".equals(platform)) {
                filename.append("-").append(platform);
            }
        }
        return filename.toString();
    }

    BaseGemFile(RubygemsFileFactory factory, FileType type, String storage, String remote, String filename) {
        this(factory, type, storage, remote, filename, null, null);
    }

    BaseGemFile(RubygemsFileFactory factory, FileType type, String storage, String remote, String name, String version, String platform) {
        super(factory, type, storage, remote, name);
        this.filename = BaseGemFile.toFilename(name, version, platform);
        this.version = version;
        this.platform = platform;
    }

    public String filename() {
        return this.filename;
    }

    public String version() {
        return this.version;
    }

    public String platform() {
        return this.platform;
    }
}

