/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.layout;

import java.io.IOException;
import java.io.InputStream;
import org.torquebox.mojo.rubygems.ApiV1File;
import org.torquebox.mojo.rubygems.BundlerApiFile;
import org.torquebox.mojo.rubygems.DependencyData;
import org.torquebox.mojo.rubygems.DependencyFile;
import org.torquebox.mojo.rubygems.DependencyHelper;
import org.torquebox.mojo.rubygems.Directory;
import org.torquebox.mojo.rubygems.GemArtifactFile;
import org.torquebox.mojo.rubygems.GemArtifactIdDirectory;
import org.torquebox.mojo.rubygems.GemFile;
import org.torquebox.mojo.rubygems.GemspecFile;
import org.torquebox.mojo.rubygems.MavenMetadataFile;
import org.torquebox.mojo.rubygems.MavenMetadataSnapshotFile;
import org.torquebox.mojo.rubygems.MetadataBuilder;
import org.torquebox.mojo.rubygems.MetadataSnapshotBuilder;
import org.torquebox.mojo.rubygems.PomFile;
import org.torquebox.mojo.rubygems.RubygemsDirectory;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.RubygemsGateway;
import org.torquebox.mojo.rubygems.Sha1Digest;
import org.torquebox.mojo.rubygems.Sha1File;
import org.torquebox.mojo.rubygems.SpecsIndexFile;
import org.torquebox.mojo.rubygems.SpecsIndexZippedFile;
import org.torquebox.mojo.rubygems.layout.DefaultLayout;
import org.torquebox.mojo.rubygems.layout.Layout;
import org.torquebox.mojo.rubygems.layout.Storage;

public class GETLayout
extends DefaultLayout
implements Layout {
    protected final RubygemsGateway gateway;
    protected final Storage store;

    public GETLayout(RubygemsGateway gateway, Storage store) {
        this.gateway = gateway;
        this.store = store;
    }

    protected void retrieveZipped(SpecsIndexZippedFile specs) {
        this.store.retrieve(specs);
    }

    @Override
    public SpecsIndexFile specsIndexFile(String name) {
        SpecsIndexFile specs = super.specsIndexFile(name);
        this.retrieveZipped(specs.zippedSpecsIndexFile());
        this.store.retrieve(specs);
        return specs;
    }

    @Override
    public SpecsIndexZippedFile specsIndexZippedFile(String name) {
        SpecsIndexZippedFile specs = super.specsIndexZippedFile(name);
        this.retrieveZipped(specs);
        return specs;
    }

    protected void retrieveAll(BundlerApiFile file, DependencyHelper deps) throws IOException {
        for (String name : file.gemnames()) {
            try (InputStream is = this.store.getInputStream(this.dependencyFile(name));){
                deps.add(is);
            }
        }
    }

    @Override
    public BundlerApiFile bundlerApiFile(String namesCommaSeparated) {
        BundlerApiFile file = super.bundlerApiFile(namesCommaSeparated);
        DependencyHelper deps = this.gateway.newDependencyHelper();
        try {
            this.retrieveAll(file, deps);
            if (!file.hasException()) {
                this.store.memory(deps.getInputStream(false), (RubygemsFile)file);
            }
        }
        catch (IOException e) {
            file.setException(e);
        }
        return file;
    }

    @Override
    public RubygemsDirectory rubygemsDirectory(String path) {
        RubygemsDirectory dir = super.rubygemsDirectory(path);
        Directory d = this.directory("/api/v1/dependencies/", new String[0]);
        dir.setItems(this.store.listDirectory(d));
        if (d.hasException()) {
            dir.setException(d.getException());
        }
        return dir;
    }

    @Override
    public GemArtifactIdDirectory gemArtifactIdDirectory(String path, String name, boolean prereleases) {
        GemArtifactIdDirectory dir = super.gemArtifactIdDirectory(path, name, prereleases);
        try {
            dir.setItems(this.newDependencyData(dir.dependency()));
        }
        catch (IOException e) {
            dir.setException(e);
        }
        return dir;
    }

    @Override
    public MavenMetadataFile mavenMetadata(String name, boolean prereleased) {
        MavenMetadataFile file = super.mavenMetadata(name, prereleased);
        try {
            MetadataBuilder meta = new MetadataBuilder(this.newDependencyData(file.dependency()));
            meta.appendVersions(file.isPrerelease());
            this.store.memory(meta.toString(), (RubygemsFile)file);
        }
        catch (IOException e) {
            file.setException(e);
        }
        return file;
    }

    @Override
    public MavenMetadataSnapshotFile mavenMetadataSnapshot(String name, String version) {
        MavenMetadataSnapshotFile file = super.mavenMetadataSnapshot(name, version);
        MetadataSnapshotBuilder meta = new MetadataSnapshotBuilder(name, version, this.store.getModified(file.dependency()));
        this.store.memory(meta.toString(), (RubygemsFile)file);
        return file;
    }

    protected void setPomPayload(PomFile file, boolean snapshot) {
        try {
            DependencyData dependencies = this.newDependencyData(file.dependency());
            if ("java".equals(dependencies.platform(file.version()))) {
                this.pomFromGem(file, snapshot, dependencies);
            } else {
                this.pomFromGemspec(file, snapshot, dependencies);
            }
        }
        catch (IOException e) {
            file.setException(e);
        }
    }

    private void pomFromGemspec(PomFile file, boolean snapshot, DependencyData dependencies) throws IOException {
        GemspecFile gemspec = file.gemspec(dependencies);
        if (gemspec.notExists()) {
            file.markAsNotExists();
        } else {
            try (InputStream is = this.store.getInputStream(gemspec);){
                this.store.memory(this.gateway.newGemspecHelper(is).pom(snapshot), (RubygemsFile)file);
            }
        }
    }

    private void pomFromGem(PomFile file, boolean snapshot, DependencyData dependencies) throws IOException {
        GemFile gem = file.gem(dependencies);
        if (gem.notExists()) {
            file.markAsNotExists();
        } else {
            try (InputStream is = this.store.getInputStream(gem);){
                this.store.memory(this.gateway.newGemspecHelperFromGem(is).pom(snapshot), (RubygemsFile)file);
            }
        }
    }

    protected void setGemArtifactPayload(GemArtifactFile file) {
        try {
            GemFile gem = file.gem(this.newDependencyData(file.dependency()));
            if (gem == null) {
                file.markAsNotExists();
            } else {
                this.store.retrieve(gem);
                file.set(gem.get());
            }
        }
        catch (IOException e) {
            file.setException(e);
        }
    }

    @Override
    public PomFile pomSnapshot(String name, String version, String timestamp) {
        PomFile file = super.pomSnapshot(name, version, timestamp);
        this.setPomPayload(file, true);
        return file;
    }

    @Override
    public PomFile pom(String name, String version) {
        PomFile file = super.pom(name, version);
        this.setPomPayload(file, false);
        return file;
    }

    @Override
    public GemArtifactFile gemArtifactSnapshot(String name, String version, String timestamp) {
        GemArtifactFile file = super.gemArtifactSnapshot(name, version, timestamp);
        this.setGemArtifactPayload(file);
        return file;
    }

    @Override
    public GemArtifactFile gemArtifact(String name, String version) {
        GemArtifactFile file = super.gemArtifact(name, version);
        this.setGemArtifactPayload(file);
        return file;
    }

    @Override
    public Sha1File sha1(RubygemsFile file) {
        Sha1File sha = super.sha1(file);
        if (sha.notExists()) {
            return sha;
        }
        try (InputStream is = this.store.getInputStream(file);){
            Sha1Digest digest = new Sha1Digest();
            int i = is.read();
            while (i != -1) {
                digest.update((byte)i);
                i = is.read();
            }
            this.store.memory(digest.hexDigest(), (RubygemsFile)sha);
        }
        catch (IOException e) {
            sha.setException(e);
        }
        return sha;
    }

    protected DependencyData newDependencyData(DependencyFile file) throws IOException {
        try (InputStream is = this.store.getInputStream(file);){
            DependencyData dependencyData = this.gateway.newDependencyData(is, file.name(), this.store.getModified(file));
            return dependencyData;
        }
    }

    @Override
    public GemFile gemFile(String name, String version, String platform) {
        GemFile gem = super.gemFile(name, version, platform);
        this.store.retrieve(gem);
        return gem;
    }

    @Override
    public GemFile gemFile(String filename) {
        GemFile gem = super.gemFile(filename);
        this.store.retrieve(gem);
        return gem;
    }

    @Override
    public GemspecFile gemspecFile(String name, String version, String platform) {
        GemspecFile gemspec = super.gemspecFile(name, version, platform);
        this.store.retrieve(gemspec);
        return gemspec;
    }

    @Override
    public GemspecFile gemspecFile(String filename) {
        GemspecFile gemspec = super.gemspecFile(filename);
        this.store.retrieve(gemspec);
        return gemspec;
    }

    @Override
    public ApiV1File apiV1File(String name) {
        ApiV1File file = super.apiV1File(name);
        if (!"api_key".equals(name)) {
            file.markAsForbidden();
        }
        return file;
    }
}

