/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.layout;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.torquebox.mojo.rubygems.BundlerApiFile;
import org.torquebox.mojo.rubygems.Directory;
import org.torquebox.mojo.rubygems.GemArtifactFile;
import org.torquebox.mojo.rubygems.IOUtil;
import org.torquebox.mojo.rubygems.MavenMetadataFile;
import org.torquebox.mojo.rubygems.MavenMetadataSnapshotFile;
import org.torquebox.mojo.rubygems.PomFile;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.RubygemsGateway;
import org.torquebox.mojo.rubygems.Sha1File;
import org.torquebox.mojo.rubygems.SpecsIndexType;
import org.torquebox.mojo.rubygems.SpecsIndexZippedFile;
import org.torquebox.mojo.rubygems.layout.DefaultLayout;
import org.torquebox.mojo.rubygems.layout.Storage;

public class NoopDefaultLayout
extends DefaultLayout {
    protected final RubygemsGateway gateway;
    protected final Storage store;

    public NoopDefaultLayout(RubygemsGateway gateway, Storage store) {
        this.gateway = gateway;
        this.store = store;
    }

    @Override
    public Sha1File sha1(RubygemsFile file) {
        Sha1File sha = super.sha1(file);
        sha.markAsForbidden();
        return sha;
    }

    @Override
    public PomFile pomSnapshot(String name, String version, String timestamp) {
        PomFile file = super.pomSnapshot(name, version, timestamp);
        file.markAsForbidden();
        return file;
    }

    @Override
    public GemArtifactFile gemArtifactSnapshot(String name, String version, String timestamp) {
        GemArtifactFile file = super.gemArtifactSnapshot(name, version, timestamp);
        file.markAsForbidden();
        return file;
    }

    @Override
    public PomFile pom(String name, String version) {
        PomFile file = super.pom(name, version);
        file.markAsForbidden();
        return file;
    }

    @Override
    public GemArtifactFile gemArtifact(String name, String version) {
        GemArtifactFile file = super.gemArtifact(name, version);
        file.markAsForbidden();
        return file;
    }

    @Override
    public MavenMetadataSnapshotFile mavenMetadataSnapshot(String name, String version) {
        MavenMetadataSnapshotFile file = super.mavenMetadataSnapshot(name, version);
        file.markAsForbidden();
        return file;
    }

    @Override
    public MavenMetadataFile mavenMetadata(String name, boolean prereleased) {
        MavenMetadataFile file = super.mavenMetadata(name, prereleased);
        file.markAsForbidden();
        return file;
    }

    @Override
    public Directory directory(String path, String ... items) {
        Directory file = super.directory(path, items);
        file.markAsForbidden();
        return file;
    }

    @Override
    public BundlerApiFile bundlerApiFile(String names) {
        BundlerApiFile file = super.bundlerApiFile(names);
        file.markAsForbidden();
        return file;
    }

    protected SpecsIndexZippedFile ensureSpecsIndexZippedFile(SpecsIndexType type) throws IOException {
        SpecsIndexZippedFile specs = super.specsIndexZippedFile(type);
        this.store.retrieve(specs);
        if (specs.notExists()) {
            try (ByteArrayInputStream content = this.gateway.newSpecsHelper().createEmptySpecs();){
                this.store.create(IOUtil.toGzipped(content), specs);
                if (specs.hasNoPayload()) {
                    this.store.retrieve(specs);
                }
                if (specs.hasException()) {
                    throw new IOException(specs.getException());
                }
            }
        }
        return specs;
    }

    protected void delete(RubygemsFile file) throws IOException {
        this.store.delete(file);
        if (file.hasException()) {
            throw new IOException(file.getException());
        }
    }
}

