/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.experiments;

import com.oracle.labs.mlrg.olcut.config.Option;
import java.util.logging.Logger;
import org.tribuo.Trainer;
import org.tribuo.classification.ClassificationOptions;
import org.tribuo.classification.Label;
import org.tribuo.classification.dtree.CARTClassificationOptions;
import org.tribuo.classification.dtree.CARTClassificationTrainer;
import org.tribuo.classification.ensemble.ClassificationEnsembleOptions;
import org.tribuo.classification.liblinear.LibLinearOptions;
import org.tribuo.classification.libsvm.LibSVMOptions;
import org.tribuo.classification.mnb.MultinomialNaiveBayesOptions;
import org.tribuo.classification.sgd.kernel.KernelSVMOptions;
import org.tribuo.classification.sgd.linear.LinearSGDOptions;
import org.tribuo.classification.xgboost.XGBoostOptions;
import org.tribuo.common.nearest.KNNClassifierOptions;
import org.tribuo.hash.HashingOptions;

public class AllTrainerOptions
implements ClassificationOptions<Trainer<Label>> {
    private static final Logger logger = Logger.getLogger(AllTrainerOptions.class.getName());
    @Option(longName="algorithm", usage="Type of learner (or base learner). Defaults to SGD_LINEAR.")
    public AlgorithmType algorithm = AlgorithmType.SGD_LINEAR;
    public CARTClassificationOptions cartOptions;
    public KNNClassifierOptions knnOptions;
    public LibLinearOptions liblinearOptions;
    public LibSVMOptions libsvmOptions;
    public MultinomialNaiveBayesOptions mnbOptions;
    public KernelSVMOptions kernelSVMOptions;
    public LinearSGDOptions linearSGDOptions;
    public XGBoostOptions xgBoostOptions;
    public ClassificationEnsembleOptions ensemble;
    public HashingOptions hashingOptions;

    public Trainer<Label> getTrainer() {
        CARTClassificationTrainer trainer;
        logger.info("Using " + (Object)((Object)this.algorithm));
        switch (this.algorithm) {
            case CART: {
                trainer = this.cartOptions.getTrainer();
                break;
            }
            case KNN: {
                trainer = this.knnOptions.getTrainer();
                break;
            }
            case LIBLINEAR: {
                trainer = this.liblinearOptions.getTrainer();
                break;
            }
            case LIBSVM: {
                trainer = this.libsvmOptions.getTrainer();
                break;
            }
            case MNB: {
                trainer = this.mnbOptions.getTrainer();
                break;
            }
            case SGD_KERNEL: {
                trainer = this.kernelSVMOptions.getTrainer();
                break;
            }
            case SGD_LINEAR: {
                trainer = this.linearSGDOptions.getTrainer();
                break;
            }
            case XGBOOST: {
                trainer = this.xgBoostOptions.getTrainer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown classifier " + (Object)((Object)this.algorithm));
            }
        }
        if (this.ensemble.ensembleSize > 0 && this.ensemble.type != null) {
            switch (this.algorithm) {
                case XGBOOST: {
                    throw new IllegalArgumentException("Not allowed to ensemble XGBoost models. Why ensemble an ensemble?");
                }
            }
            trainer = this.ensemble.wrapTrainer((Trainer)trainer);
        }
        if (this.hashingOptions.modelHashingAlgorithm != HashingOptions.ModelHashingType.NONE) {
            trainer = this.hashingOptions.getHashedTrainer((Trainer)trainer);
        }
        logger.info("Trainer description " + trainer.toString());
        return trainer;
    }

    public static enum AlgorithmType {
        CART,
        KNN,
        LIBLINEAR,
        LIBSVM,
        MNB,
        SGD_KERNEL,
        SGD_LINEAR,
        XGBOOST;

    }
}

