/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.experiments;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import java.io.IOException;
import java.util.logging.Logger;
import org.tribuo.Trainer;
import org.tribuo.classification.Label;
import org.tribuo.classification.TrainTestHelper;
import org.tribuo.classification.experiments.AllTrainerOptions;
import org.tribuo.data.DataOptions;

public class TrainTest {
    private static final Logger logger = Logger.getLogger(TrainTest.class.getName());

    public static void main(String[] args) throws IOException {
        AllClassificationOptions o = new AllClassificationOptions();
        try (ConfigurationManager cm = new ConfigurationManager(args, (Options)o);){
            Trainer<Label> trainer = o.trainerOptions.getTrainer();
            TrainTestHelper.run((ConfigurationManager)cm, (DataOptions)o.general, trainer);
        }
        catch (UsageException e) {
            logger.info(e.getMessage());
            return;
        }
    }

    public static class AllClassificationOptions
    implements Options {
        public AllTrainerOptions trainerOptions;
        public DataOptions general;

        public String getOptionsDescription() {
            return "Trains and tests the specified classifier on the supplied datasets.";
        }
    }
}

