/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.explanations.lime;

import java.util.List;
import java.util.Map;
import org.tribuo.Prediction;
import org.tribuo.SparseModel;
import org.tribuo.classification.Label;
import org.tribuo.classification.explanations.Explanation;
import org.tribuo.regression.Regressor;
import org.tribuo.regression.evaluation.RegressionEvaluation;

public class LIMEExplanation
implements Explanation<Regressor> {
    private static final long serialVersionUID = 1L;
    private final SparseModel<Regressor> model;
    private final Prediction<Label> prediction;
    private final RegressionEvaluation evaluation;

    public LIMEExplanation(SparseModel<Regressor> model, Prediction<Label> prediction, RegressionEvaluation evaluation) {
        this.model = model;
        this.prediction = prediction;
        this.evaluation = evaluation;
    }

    @Override
    public List<String> getActiveFeatures() {
        Map features = this.model.getActiveFeatures();
        if (features.containsKey("ALL_OUTPUTS")) {
            return (List)features.get("ALL_OUTPUTS");
        }
        return (List)features.get(((Label)this.prediction.getOutput()).getLabel());
    }

    @Override
    public SparseModel<Regressor> getModel() {
        return this.model;
    }

    @Override
    public Prediction<Label> getPrediction() {
        return this.prediction;
    }

    public RegressionEvaluation getEvaluation() {
        return this.evaluation;
    }

    public double getRMSE(String name) {
        return (Double)this.evaluation.rmse().get(new Regressor.DimensionTuple(name, Double.NaN));
    }

    public String toString() {
        return "LIMEExplanation(linearRMSE=" + this.evaluation.rmse() + ",modelPrediction=" + this.prediction + ",activeFeatures=" + this.getActiveFeatures().toString() + ")";
    }
}

