/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.fs;

import org.tribuo.Dataset;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.classification.Label;
import org.tribuo.classification.fs.DenseFSMatrix;

interface FSMatrix {
    public static FSMatrix buildMatrix(Dataset<Label> dataset, int numBins) {
        return DenseFSMatrix.equalWidthBins(dataset, numBins);
    }

    public int getNumFeatures();

    public int getNumSamples();

    public ImmutableFeatureMap getFeatureMap();

    public double mi(int var1);

    public double mi(int var1, int var2);

    default public double[] miList() {
        int numFeatures = this.getNumFeatures();
        double[] row = new double[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            row[i] = this.mi(i);
        }
        return row;
    }

    default public double[] miList(int targetIndex) {
        int numFeatures = this.getNumFeatures();
        double[] row = new double[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            row[i] = this.mi(i, targetIndex);
        }
        return row;
    }

    public double jmi(int var1, int var2);

    public double jmi(int var1, int var2, int var3);

    default public double[] jmiList(int jointIndex) {
        int numFeatures = this.getNumFeatures();
        double[] row = new double[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            row[i] = this.jmi(i, jointIndex);
        }
        return row;
    }

    default public double[] jmiList(int secondIndex, int targetIndex) {
        int numFeatures = this.getNumFeatures();
        double[] row = new double[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            row[i] = this.jmi(i, secondIndex, targetIndex);
        }
        return row;
    }

    public double cmi(int var1, int var2);

    public double cmi(int var1, int var2, int var3);

    default public double[] cmiList(int conditionIndex) {
        int numFeatures = this.getNumFeatures();
        double[] row = new double[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            row[i] = this.cmi(i, conditionIndex);
        }
        return row;
    }

    default public double[] cmiList(int featureIndex, int conditionIndex) {
        int numFeatures = this.getNumFeatures();
        double[] row = new double[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            row[i] = this.cmi(i, featureIndex, conditionIndex);
        }
        return row;
    }
}

