/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.fs;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.util.SortUtil;
import java.util.ArrayList;
import org.tribuo.Dataset;
import org.tribuo.FeatureSelector;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.SelectedFeatureSet;
import org.tribuo.classification.Label;
import org.tribuo.classification.fs.FSMatrix;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.FeatureSelectorProvenance;
import org.tribuo.provenance.FeatureSetProvenance;
import org.tribuo.provenance.impl.FeatureSelectorProvenanceImpl;

public final class MIM
implements FeatureSelector<Label> {
    @Config(mandatory=true, description="Number of bins to use when discretising continuous features.")
    private int numBins;
    @Config(description="Number of features to select, defaults to ranking all features.")
    private int k = -1;

    private MIM() {
    }

    public MIM(int numBins) {
        this(-1, numBins);
    }

    public MIM(int k, int numBins) {
        this.numBins = numBins;
        this.k = k;
        if (k != -1 && k < 1) {
            throw new IllegalArgumentException("k must be -1 to select all features, or a positive number, found " + k);
        }
        if (numBins < 2) {
            throw new IllegalArgumentException("numBins must be >= 2, found " + numBins);
        }
    }

    public void postConfig() {
        if (this.k != -1 && this.k < 1) {
            throw new PropertyException("", "k", "k must be -1 to select all features, or a positive number, found " + this.k);
        }
        if (this.numBins < 2) {
            throw new PropertyException("", "numBins", "numBins must be >= 2, found " + this.numBins);
        }
    }

    public boolean isOrdered() {
        return true;
    }

    public SelectedFeatureSet select(Dataset<Label> dataset) {
        FSMatrix data = FSMatrix.buildMatrix(dataset, this.numBins);
        ImmutableFeatureMap fmap = data.getFeatureMap();
        int max = this.k == -1 ? fmap.size() : Math.min(this.k, fmap.size());
        double[] mi = data.miList();
        int[] sortOrder = SortUtil.argsort((double[])mi, (boolean)false);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Double> scores = new ArrayList<Double>();
        for (int i = 0; i < max; ++i) {
            int id = sortOrder[i];
            names.add(fmap.get(id).getName());
            scores.add(mi[id]);
        }
        FeatureSetProvenance provenance = new FeatureSetProvenance(SelectedFeatureSet.class.getName(), (DatasetProvenance)dataset.getProvenance(), this.getProvenance());
        return new SelectedFeatureSet(names, scores, this.isOrdered(), provenance);
    }

    public FeatureSelectorProvenance getProvenance() {
        return new FeatureSelectorProvenanceImpl((FeatureSelector)this);
    }
}

