/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering.hdbscan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class ExtendedMinimumSpanningTree {
    private final int numVertices;
    private final EMSTTriple[] emstTriples;
    private final List<Integer>[] edges;

    ExtendedMinimumSpanningTree(int numVertices, int[] firstVertices, int[] secondVertices, double[] edgeWeights) {
        int i;
        this.numVertices = numVertices;
        List[] edgeTmp = new ArrayList[numVertices];
        this.edges = edgeTmp;
        for (i = 0; i < this.edges.length; ++i) {
            this.edges[i] = new ArrayList<Integer>(1 + edgeWeights.length / numVertices);
        }
        this.emstTriples = new EMSTTriple[edgeWeights.length];
        for (i = 0; i < edgeWeights.length; ++i) {
            EMSTTriple emstTriple;
            int vertexOne = firstVertices[i];
            int vertexTwo = secondVertices[i];
            this.edges[vertexOne].add(vertexTwo);
            if (vertexOne != vertexTwo) {
                this.edges[vertexTwo].add(vertexOne);
            }
            this.emstTriples[i] = emstTriple = new EMSTTriple(vertexOne, vertexTwo, edgeWeights[i]);
        }
        Arrays.sort(this.emstTriples);
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public int getNumEdges() {
        return this.emstTriples.length;
    }

    public int getFirstVertexAtIndex(int index) {
        return this.emstTriples[index].firstVertex;
    }

    public int getSecondVertexAtIndex(int index) {
        return this.emstTriples[index].secondVertex;
    }

    public double getEdgeWeightAtIndex(int index) {
        return this.emstTriples[index].edgeWeight;
    }

    public List<Integer> getEdgeListForVertex(int vertex) {
        return this.edges[vertex];
    }

    private static final class EMSTTriple
    implements Comparable<EMSTTriple> {
        final int firstVertex;
        final int secondVertex;
        final double edgeWeight;

        EMSTTriple(int firstVertex, int secondVertex, double edgeWeight) {
            this.firstVertex = firstVertex;
            this.secondVertex = secondVertex;
            this.edgeWeight = edgeWeight;
        }

        @Override
        public int compareTo(EMSTTriple that) {
            return Double.compare(this.edgeWeight, that.edgeWeight);
        }
    }
}

