/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering.hdbscan;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

final class HdbscanCluster
implements Comparable<HdbscanCluster> {
    private final int label;
    private final double birthLevel;
    private double splitLevel;
    private int numPoints;
    private double stability;
    private double propagatedStability;
    private double propagatedLowestChildSplitLevel;
    private final HdbscanCluster parent;
    private boolean hasChildren;
    private final List<HdbscanCluster> propagatedDescendants;
    private int hierarchyLevel = 0;
    static final HdbscanCluster NOT_A_CLUSTER = new HdbscanCluster(-1, null, Double.NaN, 0);

    HdbscanCluster(int label, HdbscanCluster parent, double birthLevel, int numPoints) {
        this.label = label;
        this.birthLevel = birthLevel;
        this.splitLevel = 0.0;
        this.numPoints = numPoints;
        this.stability = 0.0;
        this.propagatedStability = 0.0;
        this.propagatedLowestChildSplitLevel = Double.MAX_VALUE;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.hasChildren = true;
        }
        this.hasChildren = false;
        this.propagatedDescendants = new ArrayList<HdbscanCluster>(1);
    }

    HdbscanCluster createNewCluster(TreeSet<Integer> points, int[] clusterLabels, int clusterLabel, double edgeWeight) {
        for (int point : points) {
            clusterLabels[point] = clusterLabel;
        }
        this.detachPoints(points.size(), edgeWeight);
        if (clusterLabel != 0) {
            return new HdbscanCluster(clusterLabel, this, edgeWeight, points.size());
        }
        return NOT_A_CLUSTER;
    }

    void detachPoints(int numPoints, double level) {
        this.numPoints -= numPoints;
        this.stability += (double)numPoints * (1.0 / level - 1.0 / this.birthLevel);
        if (this.numPoints == 0) {
            this.splitLevel = level;
        } else if (this.numPoints < 0) {
            throw new IllegalStateException("Cluster cannot have less than 0 points.");
        }
    }

    void propagate() {
        if (this.parent != null) {
            if (this.propagatedLowestChildSplitLevel == Double.MAX_VALUE) {
                this.propagatedLowestChildSplitLevel = this.splitLevel;
            }
            if (this.propagatedLowestChildSplitLevel < this.parent.propagatedLowestChildSplitLevel) {
                this.parent.propagatedLowestChildSplitLevel = this.propagatedLowestChildSplitLevel;
            }
            if (!this.hasChildren) {
                this.parent.propagatedStability += this.stability;
                this.parent.propagatedDescendants.add(this);
            } else if (this.stability >= this.propagatedStability) {
                this.parent.propagatedStability += this.stability;
                this.parent.propagatedDescendants.add(this);
            } else {
                this.parent.propagatedStability += this.propagatedStability;
                this.parent.propagatedDescendants.addAll(this.propagatedDescendants);
            }
        }
    }

    int getLabel() {
        return this.label;
    }

    HdbscanCluster getParent() {
        return this.parent;
    }

    double getPropagatedLowestChildSplitLevel() {
        return this.propagatedLowestChildSplitLevel;
    }

    List<HdbscanCluster> getPropagatedDescendants() {
        return this.propagatedDescendants;
    }

    boolean hasChildren() {
        return this.hasChildren;
    }

    int getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    void setHierarchyLevel(int hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
    }

    @Override
    public int compareTo(HdbscanCluster that) {
        int val = Integer.compare(this.label, that.label);
        if (val == 0) {
            return val;
        }
        return -val;
    }
}

