/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering.hdbscan;

import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import java.util.logging.Logger;
import org.tribuo.clustering.hdbscan.HdbscanTrainer;
import org.tribuo.math.distance.DistanceType;
import org.tribuo.math.neighbour.NeighboursQueryFactoryType;

public final class HdbscanOptions
implements Options {
    private static final Logger logger = Logger.getLogger(HdbscanOptions.class.getName());
    @Option(longName="hdbscan-minimum-cluster-size", usage="The minimum number of points required to form a cluster.")
    public int minClusterSize = 5;
    @Option(longName="hdbscan-distance-type", usage="The type of distance function to use for various distance calculations.")
    public DistanceType distType = DistanceType.L2;
    @Option(longName="hdbscan-k-nearest-neighbors", usage="The number of nearest-neighbors to use in the initial density approximation. The value includes the point itself.")
    public int k = 5;
    @Option(longName="hdbscan-num-threads", usage="Number of threads to use for training the hdbscan model.")
    public int numThreads = 2;
    @Option(longName="hdbscan-neighbour-query-factory-type", usage="The nearest neighbour implementation factory to use.")
    public NeighboursQueryFactoryType nqFactoryType = NeighboursQueryFactoryType.KD_TREE;

    public String getOptionsDescription() {
        return "Options for configuring a HdbscanTrainer.";
    }

    public HdbscanTrainer getTrainer() {
        logger.info("Configuring Hdbscan Trainer");
        return new HdbscanTrainer(this.minClusterSize, this.distType.getDistance(), this.k, this.numThreads, this.nqFactoryType);
    }
}

