/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering.hdbscan;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.util.LabsLogFormatter;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.IOException;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Model;
import org.tribuo.OutputFactory;
import org.tribuo.clustering.ClusteringFactory;
import org.tribuo.clustering.evaluation.ClusteringEvaluation;
import org.tribuo.clustering.hdbscan.HdbscanOptions;
import org.tribuo.clustering.hdbscan.HdbscanTrainer;
import org.tribuo.data.DataOptions;

public final class TrainTest {
    private static final Logger logger = Logger.getLogger(TrainTest.class.getName());

    public static void main(String[] args) throws IOException {
        ConfigurationManager cm;
        LabsLogFormatter.setAllLogFormatters();
        HdbscanCLIOptions o = new HdbscanCLIOptions();
        try {
            cm = new ConfigurationManager(args, (Options)o);
        }
        catch (UsageException e) {
            logger.info(e.getMessage());
            return;
        }
        if (o.general.trainingPath == null) {
            logger.info(cm.usage());
            return;
        }
        ClusteringFactory factory = new ClusteringFactory();
        Pair data = o.general.load((OutputFactory)factory);
        Dataset train = (Dataset)data.getA();
        HdbscanTrainer trainer = o.hdbscanOptions.getTrainer();
        Model model = trainer.train(train);
        logger.info("Finished training model");
        ClusteringEvaluation evaluation = (ClusteringEvaluation)factory.getEvaluator().evaluate(model, train);
        logger.info("Finished evaluating model");
        System.out.println("Normalized MI = " + evaluation.normalizedMI());
        System.out.println("Adjusted MI = " + evaluation.adjustedMI());
        if (o.general.outputPath != null) {
            o.general.saveModel(model);
        }
    }

    public static class HdbscanCLIOptions
    implements Options {
        public DataOptions general;
        public HdbscanOptions hdbscanOptions;

        public String getOptionsDescription() {
            return "Trains and evaluates a HDBSCAN* model on the specified dataset.";
        }
    }
}

