/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.liblinear;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.SolverType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.tribuo.Example;
import org.tribuo.Excuse;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.common.liblinear.protos.LibLinearModelProto;
import org.tribuo.common.liblinear.protos.LibLinearProto;
import org.tribuo.impl.ModelDataCarrier;
import org.tribuo.protos.core.ModelProto;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.util.Util;

public abstract class LibLinearModel<T extends Output<T>>
extends Model<T> {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(LibLinearModel.class.getName());
    public static final int CURRENT_VERSION = 0;
    protected List<de.bwaldvogel.liblinear.Model> models;

    protected LibLinearModel(String name, ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> labelIDMap, boolean generatesProbabilities, List<de.bwaldvogel.liblinear.Model> models) {
        super(name, description, featureIDMap, labelIDMap, generatesProbabilities);
        this.models = models;
        Linear.disableDebugOutput();
    }

    public List<de.bwaldvogel.liblinear.Model> getInnerModels() {
        ArrayList<de.bwaldvogel.liblinear.Model> copy = new ArrayList<de.bwaldvogel.liblinear.Model>();
        for (de.bwaldvogel.liblinear.Model m : this.models) {
            copy.add(LibLinearModel.copyModel(m));
        }
        return Collections.unmodifiableList(copy);
    }

    public Optional<Excuse<T>> getExcuse(Example<T> e) {
        double[][] featureWeights = this.getFeatureWeights();
        return Optional.of(this.innerGetExcuse(e, featureWeights));
    }

    public Optional<List<Excuse<T>>> getExcuses(Iterable<Example<T>> examples) {
        double[][] featureWeights = this.getFeatureWeights();
        ArrayList<Excuse<T>> excuses = new ArrayList<Excuse<T>>();
        for (Example<T> e : examples) {
            excuses.add(this.innerGetExcuse(e, featureWeights));
        }
        return Optional.of(excuses);
    }

    protected static de.bwaldvogel.liblinear.Model copyModel(de.bwaldvogel.liblinear.Model model) {
        try {
            StringWriter writer = new StringWriter();
            Linear.saveModel((Writer)writer, (de.bwaldvogel.liblinear.Model)model);
            String modelString = writer.toString();
            StringReader reader = new StringReader(modelString);
            return Linear.loadModel((Reader)reader);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException found when copying the model in memory via a String.", e);
        }
    }

    protected abstract double[][] getFeatureWeights();

    protected abstract Excuse<T> innerGetExcuse(Example<T> var1, double[][] var2);

    public ModelProto serialize() {
        ModelDataCarrier carrier = this.createDataCarrier();
        LibLinearModelProto.Builder modelBuilder = LibLinearModelProto.newBuilder();
        modelBuilder.setMetadata(carrier.serialize());
        for (de.bwaldvogel.liblinear.Model m : this.models) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(m);
                oos.close();
                modelBuilder.addModels(ByteString.copyFrom((byte[])baos.toByteArray()));
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not serialize liblinear model to byte array");
            }
        }
        ModelProto.Builder builder = ModelProto.newBuilder();
        builder.setSerializedData(Any.pack((Message)modelBuilder.build()));
        builder.setClassName(((Object)((Object)this)).getClass().getName());
        builder.setVersion(0);
        return builder.build();
    }

    private static LibLinearProto serializeModel(de.bwaldvogel.liblinear.Model model) {
        LibLinearProto.Builder builder = LibLinearProto.newBuilder();
        builder.setBias(model.getBias());
        builder.addAllLabel(Arrays.stream(model.getLabels()).boxed().collect(Collectors.toList()));
        builder.setNrClass(model.getNrClass());
        builder.setNrFeature(model.getNrFeature());
        builder.setSolverType(model.getSolverType().name());
        builder.addAllW(Arrays.stream(model.getFeatureWeights()).boxed().collect(Collectors.toList()));
        if (model.getSolverType().isOneClass()) {
            builder.setRho(model.getDecfunRho());
        }
        return builder.build();
    }

    private static de.bwaldvogel.liblinear.Model deserializeModels(LibLinearProto proto) {
        de.bwaldvogel.liblinear.Model model = new de.bwaldvogel.liblinear.Model();
        Class<de.bwaldvogel.liblinear.Model> modelClass = de.bwaldvogel.liblinear.Model.class;
        LibLinearModel.setField(modelClass, "bias", model, proto.getBias());
        LibLinearModel.setField(modelClass, "label", model, Util.toPrimitiveInt(proto.getLabelList()));
        LibLinearModel.setField(modelClass, "nr_class", model, proto.getNrClass());
        LibLinearModel.setField(modelClass, "nr_feature", model, proto.getNrFeature());
        LibLinearModel.setField(modelClass, "solverType", model, SolverType.valueOf((String)proto.getSolverType()));
        LibLinearModel.setField(modelClass, "w", model, Util.toPrimitiveDouble(proto.getWList()));
        LibLinearModel.setField(modelClass, "rho", model, proto.getRho());
        return model;
    }

    private static <U> void setField(Class<U> clazz, String fieldName, U host, Object value) {
        try {
            Field biasField = clazz.getField(fieldName);
            biasField.setAccessible(true);
            biasField.set(host, value);
            biasField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Failed to write to field " + fieldName, e);
        }
    }
}

