/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.tree;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.common.tree.Node;
import org.tribuo.common.tree.TreeModel;
import org.tribuo.common.tree.protos.LeafNodeProto;
import org.tribuo.common.tree.protos.TreeNodeProto;
import org.tribuo.math.la.SparseVector;
import org.tribuo.protos.core.OutputProto;

public class LeafNode<T extends Output<T>>
implements Node<T> {
    private static final long serialVersionUID = 4L;
    public static final int CURRENT_VERSION = 0;
    private final double impurity;
    private final T output;
    private final Map<String, T> scores;
    private final boolean generatesProbabilities;

    public LeafNode(double impurity, T output, Map<String, T> scores, boolean generatesProbabilities) {
        this.impurity = impurity;
        this.output = output;
        this.scores = Collections.unmodifiableMap(scores);
        this.generatesProbabilities = generatesProbabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafNode leafNode = (LeafNode)o;
        if (this.output.getClass().equals(leafNode.output.getClass())) {
            LeafNode typedLeafNode = leafNode;
            if (this.scores.keySet().equals(typedLeafNode.scores.keySet())) {
                boolean valueEquals = true;
                for (Map.Entry<String, T> e : this.scores.entrySet()) {
                    valueEquals &= ((Output)e.getValue()).fullEquals((Output)typedLeafNode.scores.get(e.getKey()));
                }
                return valueEquals && Double.compare(typedLeafNode.impurity, this.impurity) == 0 && this.generatesProbabilities == typedLeafNode.generatesProbabilities && this.output.fullEquals(typedLeafNode.output);
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.impurity, this.output, this.scores, this.generatesProbabilities);
    }

    @Override
    public Node<T> getNextNode(SparseVector e) {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public double getImpurity() {
        return this.impurity;
    }

    @Override
    public LeafNode<T> copy() {
        return new LeafNode<Output>(this.impurity, this.output.copy(), new HashMap<String, T>(this.scores), this.generatesProbabilities);
    }

    public T getOutput() {
        return this.output;
    }

    public Map<String, T> getDistribution() {
        return this.scores;
    }

    public Prediction<T> getPrediction(int numUsed, Example<T> example) {
        return new Prediction(this.output, this.scores, numUsed, example, this.generatesProbabilities);
    }

    public String toString() {
        return "LeafNode(impurity=" + this.impurity + ",output=" + this.output.toString() + ",scores=" + this.scores.toString() + ",probability=" + this.generatesProbabilities + ")";
    }

    TreeNodeProto serialize(int parentIdx, int curIdx) {
        LeafNodeProto.Builder nodeBuilder = LeafNodeProto.newBuilder();
        nodeBuilder.setParentIdx(parentIdx);
        nodeBuilder.setCurIdx(curIdx);
        nodeBuilder.setOutput((OutputProto)this.output.serialize());
        for (Map.Entry<String, T> e : this.scores.entrySet()) {
            nodeBuilder.putScore(e.getKey(), (OutputProto)((Output)e.getValue()).serialize());
        }
        nodeBuilder.setGeneratesProbabilities(this.generatesProbabilities);
        nodeBuilder.setImpurity(this.impurity);
        TreeNodeProto.Builder builder = TreeNodeProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(LeafNode.class.getName());
        builder.setSerializedData(Any.pack((Message)nodeBuilder.build()));
        return builder.build();
    }

    static final class LeafNodeBuilder<T extends Output<T>>
    extends TreeModel.NodeBuilder
    implements Node<T> {
        private final int parentIdx;
        private final int curIdx;
        private final double impurity;
        private final T output;
        private final Map<String, T> scores;
        private final boolean generatesProbabilities;

        LeafNodeBuilder(LeafNodeProto proto) {
            this.parentIdx = proto.getParentIdx();
            this.curIdx = proto.getCurIdx();
            this.impurity = proto.getImpurity();
            this.output = Output.deserialize((OutputProto)proto.getOutput());
            this.scores = new HashMap<String, T>();
            for (Map.Entry<String, OutputProto> e : proto.getScoreMap().entrySet()) {
                Output curOutput = Output.deserialize((OutputProto)e.getValue());
                if (!curOutput.getClass().equals(this.output.getClass())) {
                    throw new IllegalStateException("Invalid protobuf, scores were not the same type as the most likely output, found " + curOutput.getClass() + ", expected " + this.output.getClass());
                }
                this.scores.put(e.getKey(), curOutput);
            }
            this.generatesProbabilities = proto.getGeneratesProbabilities();
        }

        LeafNodeBuilder(int parentIdx, int curIdx, double impurity, T output, Map<String, T> scores, boolean generatesProbabilities) {
            this.parentIdx = parentIdx;
            this.curIdx = curIdx;
            this.impurity = impurity;
            this.output = output;
            this.scores = scores;
            this.generatesProbabilities = generatesProbabilities;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Node<T> getNextNode(SparseVector example) {
            return null;
        }

        @Override
        public double getImpurity() {
            return this.impurity;
        }

        @Override
        public LeafNodeBuilder<T> copy() {
            return new LeafNodeBuilder<Output>(this.parentIdx, this.curIdx, this.impurity, this.output.copy(), new HashMap<String, T>(this.scores), this.generatesProbabilities);
        }

        @Override
        int getParentIdx() {
            return this.parentIdx;
        }

        @Override
        int getCurIdx() {
            return this.curIdx;
        }

        LeafNode<T> build() {
            return new LeafNode<Output>(this.impurity, this.output.copy(), new HashMap<String, T>(this.scores), this.generatesProbabilities);
        }
    }
}

