/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.tree;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.Objects;
import org.tribuo.Output;
import org.tribuo.common.tree.LeafNode;
import org.tribuo.common.tree.Node;
import org.tribuo.common.tree.TreeModel;
import org.tribuo.common.tree.protos.SplitNodeProto;
import org.tribuo.common.tree.protos.TreeNodeProto;
import org.tribuo.math.la.SparseVector;

public class SplitNode<T extends Output<T>>
implements Node<T> {
    private static final long serialVersionUID = 3L;
    public static final int CURRENT_VERSION = 0;
    private final Node<T> greaterThan;
    private final Node<T> lessThanOrEqual;
    private final int splitFeature;
    private final double splitValue;
    private final double impurity;

    public SplitNode(double splitValue, int featureID, double impurity, Node<T> greaterThan, Node<T> lessThanOrEqual) {
        this.splitValue = splitValue;
        this.splitFeature = featureID;
        this.impurity = impurity;
        this.greaterThan = greaterThan;
        this.lessThanOrEqual = lessThanOrEqual;
    }

    @Override
    public Node<T> getNextNode(SparseVector e) {
        double feature = e.get(this.splitFeature);
        if (feature > this.splitValue) {
            return this.greaterThan;
        }
        return this.lessThanOrEqual;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public double getImpurity() {
        return this.impurity;
    }

    @Override
    public Node<T> copy() {
        return new SplitNode<T>(this.splitValue, this.splitFeature, this.impurity, this.greaterThan.copy(), this.lessThanOrEqual.copy());
    }

    public int getFeatureID() {
        return this.splitFeature;
    }

    public double splitValue() {
        return this.splitValue;
    }

    public Node<T> getGreaterThan() {
        return this.greaterThan;
    }

    public Node<T> getLessThanOrEqual() {
        return this.lessThanOrEqual;
    }

    public String toString() {
        return "SplitNode(feature=" + this.splitFeature + ",value=" + this.splitValue + ",impurity=" + this.impurity + ",\n\t\tleft=" + this.lessThanOrEqual.toString() + ",\n\t\tright=" + this.greaterThan.toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitNode splitNode = (SplitNode)o;
        return this.splitFeature == splitNode.splitFeature && Double.compare(splitNode.splitValue, this.splitValue) == 0 && Double.compare(splitNode.impurity, this.impurity) == 0 && this.greaterThan.equals(splitNode.greaterThan) && this.lessThanOrEqual.equals(splitNode.lessThanOrEqual);
    }

    public int hashCode() {
        return Objects.hash(this.greaterThan, this.lessThanOrEqual, this.splitFeature, this.splitValue, this.impurity);
    }

    TreeNodeProto serialize(int parentIdx, int curIdx, int greaterThanIdx, int lessThanOrEqualIdx) {
        SplitNodeProto.Builder nodeBuilder = SplitNodeProto.newBuilder();
        nodeBuilder.setParentIdx(parentIdx);
        nodeBuilder.setCurIdx(curIdx);
        nodeBuilder.setGreaterThanIdx(greaterThanIdx);
        nodeBuilder.setLessThanOrEqualIdx(lessThanOrEqualIdx);
        nodeBuilder.setSplitFeatureIdx(this.splitFeature);
        nodeBuilder.setSplitValue(this.splitValue);
        nodeBuilder.setImpurity(this.impurity);
        TreeNodeProto.Builder builder = TreeNodeProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(LeafNode.class.getName());
        builder.setSerializedData(Any.pack((Message)nodeBuilder.build()));
        return builder.build();
    }

    static final class SplitNodeBuilder<T extends Output<T>>
    extends TreeModel.NodeBuilder
    implements Node<T> {
        private final int parentIdx;
        private final int curIdx;
        private final int greaterThanIdx;
        private final int lessThanOrEqualIdx;
        private final int splitFeature;
        private final double splitValue;
        private final double impurity;
        private Node<T> greaterThan;
        private Node<T> lessThanOrEqual;

        SplitNodeBuilder(SplitNodeProto proto) {
            this.parentIdx = proto.getParentIdx();
            this.curIdx = proto.getCurIdx();
            this.greaterThanIdx = proto.getGreaterThanIdx();
            this.lessThanOrEqualIdx = proto.getLessThanOrEqualIdx();
            this.splitFeature = proto.getSplitFeatureIdx();
            this.splitValue = proto.getSplitValue();
            this.impurity = proto.getImpurity();
        }

        SplitNodeBuilder(int parentIdx, int curIdx, int greaterThanIdx, int lessThanOrEqualIdx, int splitFeature, double splitValue, double impurity) {
            this.parentIdx = parentIdx;
            this.curIdx = curIdx;
            this.greaterThanIdx = greaterThanIdx;
            this.lessThanOrEqualIdx = lessThanOrEqualIdx;
            this.splitFeature = splitFeature;
            this.splitValue = splitValue;
            this.impurity = impurity;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public Node<T> getNextNode(SparseVector example) {
            return null;
        }

        @Override
        public double getImpurity() {
            return this.impurity;
        }

        @Override
        public SplitNodeBuilder<T> copy() {
            return new SplitNodeBuilder<T>(this.parentIdx, this.curIdx, this.greaterThanIdx, this.lessThanOrEqualIdx, this.splitFeature, this.splitValue, this.impurity);
        }

        boolean canBuild() {
            return this.greaterThan != null && this.lessThanOrEqual != null;
        }

        SplitNode<T> build() {
            if (!this.canBuild()) {
                throw new IllegalStateException("Not ready to build this split node, missing the children pointers");
            }
            return new SplitNode<T>(this.splitValue, this.splitFeature, this.impurity, this.greaterThan, this.lessThanOrEqual);
        }

        void setGreaterThan(Node<T> greaterThan) {
            if (this.greaterThan != null) {
                throw new IllegalStateException("Invalid protobuf, multiple nodes mapped to the greaterThanIdx");
            }
            this.greaterThan = greaterThan;
        }

        void setLessThanOrEqual(Node<T> lessThanOrEqual) {
            if (this.lessThanOrEqual != null) {
                throw new IllegalStateException("Invalid protobuf, multiple nodes mapped to the lessThanOrEqualIdx");
            }
            this.lessThanOrEqual = lessThanOrEqual;
        }

        int getGreaterThanIdx() {
            return this.greaterThanIdx;
        }

        int getLessThanOrEqualIdx() {
            return this.lessThanOrEqualIdx;
        }

        @Override
        int getParentIdx() {
            return this.parentIdx;
        }

        @Override
        int getCurIdx() {
            return this.curIdx;
        }
    }
}

