/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import com.oracle.labs.mlrg.olcut.util.LabsLogFormatter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.tribuo.ConfigurableDataSource;
import org.tribuo.MutableDataset;
import org.tribuo.Output;

public final class PreprocessAndSerialize {
    private static final Logger logger = Logger.getLogger(PreprocessAndSerialize.class.getName());

    private PreprocessAndSerialize() {
    }

    public static void main(String[] args) {
        LabsLogFormatter.setAllLogFormatters();
        PreprocessAndSerializeOptions opts = new PreprocessAndSerializeOptions();
        try {
            ConfigurationManager cm = new ConfigurationManager(args, (Options)opts);
        }
        catch (UsageException e) {
            logger.info(e.getUsage());
            System.exit(1);
        }
        logger.info("Reading datasource into dataset");
        MutableDataset dataset = new MutableDataset(opts.dataSource);
        logger.info("Finished reading dataset");
        if (opts.output.endsWith("gz")) {
            logger.info("Writing zipped dataset");
        }
        if (opts.protobufFormat) {
            try (OutputStream os = opts.output.endsWith("gz") ? new GZIPOutputStream(Files.newOutputStream(opts.output, new OpenOption[0])) : Files.newOutputStream(opts.output, new OpenOption[0]);){
                dataset.serializeToStream(os);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error writing serialized dataset", e);
            }
        } else {
            try (ObjectOutputStream os = IOUtil.getObjectOutputStream((String)opts.output.toString(), (boolean)opts.output.endsWith("gz"));){
                os.writeObject(dataset);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error writing serialized dataset", e);
                System.exit(1);
            }
        }
    }

    public static class PreprocessAndSerializeOptions
    implements Options {
        @Option(charName=100, longName="dataSource", usage="Datasource to load from a config file")
        public ConfigurableDataSource<? extends Output<?>> dataSource;
        @Option(charName=111, longName="serialized-dataset", usage="path to serialize the dataset")
        public Path output;
        @Option(charName=112, longName="save-as-protobuf", usage="Save the dataset as a protobuf.")
        public boolean protobufFormat;
    }
}

