/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.VariableInfo;
import org.tribuo.data.columnar.ColumnarFeature;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.data.columnar.FeatureProcessor;
import org.tribuo.data.columnar.FieldExtractor;
import org.tribuo.data.columnar.FieldProcessor;
import org.tribuo.data.columnar.ResponseProcessor;
import org.tribuo.impl.ArrayExample;

public class RowProcessor<T extends Output<T>>
implements Configurable,
Provenancable<ConfiguredObjectProvenance> {
    private static final Logger logger = Logger.getLogger(RowProcessor.class.getName());
    private static final String FEATURE_NAME_REGEX = "[@#]";
    private static final Pattern FEATURE_NAME_PATTERN = Pattern.compile("[@#]");
    @Config(description="Extractors for the example metadata.")
    private List<FieldExtractor<?>> metadataExtractors = Collections.emptyList();
    @Config(description="Extractor for the example weight.")
    protected FieldExtractor<Float> weightExtractor = null;
    @Config(mandatory=true, description="Processor which extracts the response.")
    protected ResponseProcessor<T> responseProcessor;
    @Config(mandatory=true, description="The list of field processors to use.")
    private List<FieldProcessor> fieldProcessorList;
    protected Map<String, FieldProcessor> fieldProcessorMap;
    @Config(description="A set of feature processors to apply after extraction.")
    private Set<FeatureProcessor> featureProcessors = new HashSet<FeatureProcessor>();
    @Config(description="A map from a regex to field processors to apply to fields matching the regex.")
    protected Map<String, FieldProcessor> regexMappingProcessors = new HashMap<String, FieldProcessor>();
    @Config(description="Replace newlines with spaces in values before passing them to field processors.")
    protected boolean replaceNewlinesWithSpaces = true;
    protected boolean configured;

    public RowProcessor(ResponseProcessor<T> responseProcessor, Map<String, FieldProcessor> fieldProcessorMap) {
        this(Collections.emptyList(), null, responseProcessor, fieldProcessorMap, Collections.emptySet());
    }

    public RowProcessor(ResponseProcessor<T> responseProcessor, Map<String, FieldProcessor> fieldProcessorMap, Set<FeatureProcessor> featureProcessors) {
        this(Collections.emptyList(), null, responseProcessor, fieldProcessorMap, featureProcessors);
    }

    @Deprecated
    public RowProcessor(List<FieldExtractor<?>> metadataExtractors, ResponseProcessor<T> responseProcessor, Map<String, FieldProcessor> fieldProcessorMap) {
        this(metadataExtractors, null, responseProcessor, fieldProcessorMap, Collections.emptySet());
    }

    @Deprecated
    public RowProcessor(List<FieldExtractor<?>> metadataExtractors, FieldExtractor<Float> weightExtractor, ResponseProcessor<T> responseProcessor, Map<String, FieldProcessor> fieldProcessorMap, Set<FeatureProcessor> featureProcessors) {
        this(metadataExtractors, weightExtractor, responseProcessor, fieldProcessorMap, Collections.emptyMap(), featureProcessors, true);
    }

    @Deprecated
    public RowProcessor(List<FieldExtractor<?>> metadataExtractors, FieldExtractor<Float> weightExtractor, ResponseProcessor<T> responseProcessor, Map<String, FieldProcessor> fieldProcessorMap, Map<String, FieldProcessor> regexMappingProcessors, Set<FeatureProcessor> featureProcessors) {
        this(metadataExtractors, weightExtractor, responseProcessor, fieldProcessorMap, regexMappingProcessors, featureProcessors, true);
    }

    @Deprecated
    public RowProcessor(List<FieldExtractor<?>> metadataExtractors, FieldExtractor<Float> weightExtractor, ResponseProcessor<T> responseProcessor, Map<String, FieldProcessor> fieldProcessorMap, Map<String, FieldProcessor> regexMappingProcessors, Set<FeatureProcessor> featureProcessors, boolean replaceNewlinesWithSpaces) {
        this.metadataExtractors = metadataExtractors.isEmpty() ? Collections.emptyList() : new ArrayList(metadataExtractors);
        this.weightExtractor = weightExtractor;
        this.responseProcessor = responseProcessor;
        this.fieldProcessorMap = new HashMap<String, FieldProcessor>(fieldProcessorMap);
        this.regexMappingProcessors = regexMappingProcessors.isEmpty() ? Collections.emptyMap() : new HashMap<String, FieldProcessor>(regexMappingProcessors);
        this.featureProcessors.addAll(featureProcessors);
        this.replaceNewlinesWithSpaces = replaceNewlinesWithSpaces;
        this.postConfig();
    }

    protected RowProcessor() {
    }

    public void postConfig() {
        this.configured = this.regexMappingProcessors.isEmpty();
        if (this.fieldProcessorList != null) {
            this.fieldProcessorMap = this.fieldProcessorList.stream().collect(Collectors.toMap(FieldProcessor::getFieldName, Function.identity()));
        } else {
            this.fieldProcessorList = new ArrayList<FieldProcessor>();
            this.fieldProcessorList.addAll(this.fieldProcessorMap.values());
        }
        HashSet<String> metadataNames = new HashSet<String>();
        for (FieldExtractor<?> extractor : this.metadataExtractors) {
            String newMetadataName = extractor.getMetadataName();
            if (metadataNames.contains(newMetadataName)) {
                throw new PropertyException("", "metadataExtractors", "Two metadata extractors found referencing the same metadata name '" + newMetadataName + "'");
            }
            metadataNames.add(newMetadataName);
        }
    }

    public ResponseProcessor<T> getResponseProcessor() {
        return this.responseProcessor;
    }

    public Map<String, FieldProcessor> getFieldProcessors() {
        return Collections.unmodifiableMap(this.fieldProcessorMap);
    }

    public Set<FeatureProcessor> getFeatureProcessors() {
        return Collections.unmodifiableSet(this.featureProcessors);
    }

    public Optional<Example<T>> generateExample(ColumnarIterator.Row row, boolean outputRequired) {
        List<String> responseValues = this.responseProcessor.getFieldNames().stream().map(f -> row.getRowData().getOrDefault(f, "")).collect(Collectors.toList());
        Optional<Output> labelOpt = this.responseProcessor.process(responseValues);
        if (!labelOpt.isPresent() && outputRequired) {
            return Optional.empty();
        }
        List<ColumnarFeature> features = this.generateFeatures(row.getRowData());
        if (features.isEmpty()) {
            logger.warning(String.format("Row %d empty of features, omitting", row.getIndex()));
            return Optional.empty();
        }
        Output label = labelOpt.orElse(this.responseProcessor.getOutputFactory().getUnknownOutput());
        Map<String, Object> metadata = this.generateMetadata(row);
        ArrayExample example = this.weightExtractor == null ? new ArrayExample(label, metadata) : new ArrayExample(label, this.weightExtractor.extract(row).orElse(Float.valueOf(1.0f)).floatValue(), metadata);
        example.addAll(features);
        return Optional.of(example);
    }

    public Optional<Example<T>> generateExample(Map<String, String> row, boolean outputRequired) {
        return this.generateExample(-1L, row, outputRequired);
    }

    public Optional<Example<T>> generateExample(long idx, Map<String, String> row, boolean outputRequired) {
        return this.generateExample(new ColumnarIterator.Row(idx, new ArrayList<String>(row.keySet()), row), outputRequired);
    }

    public Map<String, Object> generateMetadata(ColumnarIterator.Row row) {
        if (this.metadataExtractors.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> metadataMap = new HashMap<String, Object>();
        long idx = row.getIndex();
        for (FieldExtractor<?> field : this.metadataExtractors) {
            String metadataName = field.getMetadataName();
            Optional<?> extractedValue = field.extract(row);
            if (extractedValue.isPresent()) {
                metadataMap.put(metadataName, extractedValue.get());
                continue;
            }
            logger.warning("Failed to extract field with name " + metadataName + " from index " + idx);
        }
        return metadataMap;
    }

    public List<ColumnarFeature> generateFeatures(Map<String, String> row) {
        if (!this.configured) {
            throw new IllegalStateException("expandRegexMapping not called, yet there are entries in regexMappingProcessors which have not been bound to a field name.");
        }
        List<ColumnarFeature> features = new ArrayList<ColumnarFeature>();
        for (Map.Entry<String, FieldProcessor> e : this.fieldProcessorMap.entrySet()) {
            String value = row.get(e.getKey());
            if (value == null) continue;
            if (this.replaceNewlinesWithSpaces) {
                value = value.replace('\n', ' ');
            }
            value = value.trim();
            features.addAll(e.getValue().process(value));
        }
        for (FeatureProcessor f : this.featureProcessors) {
            features = f.process(features);
        }
        return features;
    }

    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.fieldProcessorMap.keySet());
    }

    public String getDescription() {
        String weightExtractorStr;
        String string = weightExtractorStr = this.weightExtractor == null ? "null" : this.weightExtractor.toString();
        if (this.configured || this.regexMappingProcessors.isEmpty()) {
            return "RowProcessor(responseProcessor=" + this.responseProcessor.toString() + ",fieldProcessorMap=" + this.fieldProcessorMap.toString() + ",featureProcessors=" + this.featureProcessors.toString() + ",metadataExtractors=" + this.metadataExtractors.toString() + ",weightExtractor=" + weightExtractorStr + ")";
        }
        return "RowProcessor(responseProcessor=" + this.responseProcessor.toString() + ",fieldProcessorMap=" + this.fieldProcessorMap.toString() + ",regexMappingProcessors=" + this.regexMappingProcessors.toString() + ",featureProcessors=" + this.featureProcessors.toString() + ",metadataExtractors=" + this.metadataExtractors.toString() + ",weightExtractor=" + weightExtractorStr + ")";
    }

    public String toString() {
        return this.getDescription();
    }

    public Map<String, Class<?>> getMetadataTypes() {
        if (this.metadataExtractors.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap types = new HashMap();
        for (FieldExtractor<?> extractor : this.metadataExtractors) {
            types.put(extractor.getMetadataName(), extractor.getValueType());
        }
        return types;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void expandRegexMapping(Model<T> model) {
        this.expandRegexMapping(model.getFeatureIDMap());
    }

    public void expandRegexMapping(ImmutableFeatureMap featureMap) {
        ArrayList<String> fieldNames = new ArrayList<String>(featureMap.size());
        for (VariableInfo v : featureMap) {
            String[] split = FEATURE_NAME_PATTERN.split(v.getName(), 1);
            String fieldName = split[0];
            fieldNames.add(fieldName);
        }
        this.expandRegexMapping(fieldNames);
    }

    public void expandRegexMapping(Collection<String> fieldNames) {
        if (this.configured) {
            logger.warning("RowProcessor was already configured, yet expandRegexMapping was called with " + fieldNames.toString());
        } else {
            Set<String> regexesMatchingFieldNames = this.partialExpandRegexMapping(fieldNames);
            if (regexesMatchingFieldNames.size() != this.regexMappingProcessors.size()) {
                throw new IllegalArgumentException("Failed to match all the regexes, found " + regexesMatchingFieldNames.size() + ", required " + this.regexMappingProcessors.size());
            }
            this.regexMappingProcessors.clear();
            this.configured = true;
        }
    }

    protected Set<String> partialExpandRegexMapping(Collection<String> fieldNames) {
        HashSet<String> regexesMatchingFieldNames = new HashSet<String>();
        for (Map.Entry<String, FieldProcessor> e : this.regexMappingProcessors.entrySet()) {
            Pattern p = Pattern.compile(e.getKey());
            for (String s : fieldNames) {
                if (!p.matcher(s).matches()) continue;
                FieldProcessor newProcessor = e.getValue().copy(s);
                this.fieldProcessorList.add(newProcessor);
                FieldProcessor f = this.fieldProcessorMap.put(s, newProcessor);
                if (f != null) {
                    throw new IllegalArgumentException("Regex " + p.toString() + " matched field " + s + " which already had a field processor " + f.toString());
                }
                regexesMatchingFieldNames.add(e.getKey());
            }
        }
        return regexesMatchingFieldNames;
    }

    @Deprecated
    public RowProcessor<T> copy() {
        return new RowProcessor<T>(this.metadataExtractors, this.weightExtractor, this.responseProcessor, this.fieldProcessorMap, this.regexMappingProcessors, this.featureProcessors, this.replaceNewlinesWithSpaces);
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "RowProcessor");
    }

    public static class Builder<T extends Output<T>> {
        private List<FieldExtractor<?>> metadataExtractors = new ArrayList();
        private FieldExtractor<Float> weightExtractor;
        private Map<String, FieldProcessor> fieldProcessors;
        private Map<String, FieldProcessor> regexMappingProcessors;
        private Set<FeatureProcessor> featureProcessors = new HashSet<FeatureProcessor>();
        private boolean replaceNewLinesWithSpaces = true;

        public Builder() {
            this.regexMappingProcessors = new HashMap<String, FieldProcessor>();
            this.fieldProcessors = new HashMap<String, FieldProcessor>();
        }

        public Builder<T> setReplaceNewLinesWithSpaces(boolean replaceNewLinesWithSpaces) {
            this.replaceNewLinesWithSpaces = replaceNewLinesWithSpaces;
            return this;
        }

        public Builder<T> setWeightExtractor(FieldExtractor<Float> weightExtractor) {
            this.weightExtractor = weightExtractor;
            return this;
        }

        public Builder<T> setMetadataExtractors(List<FieldExtractor<?>> metadataExtractors) {
            this.metadataExtractors = metadataExtractors;
            return this;
        }

        public Builder<T> addMetadataExtractor(FieldExtractor<?> metadataExtractor) {
            this.metadataExtractors.add(metadataExtractor);
            return this;
        }

        public Builder<T> setFeatureProcessors(Set<FeatureProcessor> featureProcessors) {
            this.featureProcessors = featureProcessors;
            return this;
        }

        public Builder<T> addFeatureProcessor(FeatureProcessor featureProcessor) {
            this.featureProcessors.add(featureProcessor);
            return this;
        }

        public Builder<T> addFieldProcessor(FieldProcessor fieldProcessor) {
            if (this.fieldProcessors.containsKey(fieldProcessor.getFieldName())) {
                logger.warning("Field name " + fieldProcessor.getFieldName() + " aleady present, overwriting");
            }
            this.fieldProcessors.put(fieldProcessor.getFieldName(), fieldProcessor);
            return this;
        }

        public Builder<T> setFieldProcessors(Iterable<FieldProcessor> fieldProcessors) {
            HashMap<String, FieldProcessor> fpMap = new HashMap<String, FieldProcessor>();
            for (FieldProcessor fieldProcessor : fieldProcessors) {
                if (fpMap.containsKey(fieldProcessor.getFieldName())) {
                    throw new IllegalArgumentException("Duplicate field name " + fieldProcessor.getFieldName());
                }
                fpMap.put(fieldProcessor.getFieldName(), fieldProcessor);
            }
            this.fieldProcessors = fpMap;
            return this;
        }

        public Optional<FieldProcessor> getFieldProcessor(String fieldName) {
            return Optional.ofNullable(this.fieldProcessors.get(fieldName));
        }

        public Builder<T> setRegexMappingProcessors(Map<String, FieldProcessor> regexMappingProcessors) {
            this.regexMappingProcessors = regexMappingProcessors;
            return this;
        }

        public Optional<FieldProcessor> getRegexFieldProcessor(String regexName) {
            return Optional.ofNullable(this.regexMappingProcessors.get(regexName));
        }

        public Builder<T> addRegexMappingProcessor(String regex, FieldProcessor fieldProcessor) {
            if (this.regexMappingProcessors.containsKey(regex)) {
                logger.warning("Regex pattern " + regex + " already present, overwriting");
            }
            this.regexMappingProcessors.put(regex, fieldProcessor);
            return this;
        }

        public RowProcessor<T> build(ResponseProcessor<T> responseProcessor) {
            if (this.fieldProcessors.isEmpty() && this.regexMappingProcessors.isEmpty()) {
                throw new IllegalArgumentException("At least one FieldProcessor must be present");
            }
            return new RowProcessor<T>(this.metadataExtractors, this.weightExtractor, responseProcessor, this.fieldProcessors, this.regexMappingProcessors, this.featureProcessors, this.replaceNewLinesWithSpaces);
        }
    }
}

