/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.tribuo.Feature;
import org.tribuo.data.text.FeatureTransformer;
import org.tribuo.util.MurmurHash3;

public class FeatureHasher
implements FeatureTransformer {
    private static final Logger logger = Logger.getLogger(FeatureHasher.class.getName());
    public static final int DEFAULT_HASH_SEED = 38495;
    public static final int DEFAULT_VALUE_HASH_SEED = 77777;
    @Config(mandatory=true, description="Dimension to map the hash into.")
    private int dimension;
    @Config(description="Seed used in the hash function.")
    private int hashSeed = 38495;
    @Config(description="Seed used for value hash function.")
    private int valueHashSeed = 77777;
    @Config(description="Preserve input feature value.")
    private boolean preserveValue = false;

    public FeatureHasher(int dimension) {
        this(dimension, false);
    }

    public FeatureHasher(int dimension, boolean preserveValue) {
        this(dimension, 38495, 77777, preserveValue);
    }

    public FeatureHasher(int dimension, int hashSeed, int valueHashSeed, boolean preserveValue) {
        this.dimension = dimension;
        this.hashSeed = hashSeed;
        this.valueHashSeed = valueHashSeed;
        this.preserveValue = preserveValue;
        this.postConfig();
    }

    private FeatureHasher() {
    }

    public void postConfig() {
        if (this.dimension < 1) {
            throw new PropertyException("", "dimension", "Dimension must be positive, found " + this.dimension);
        }
    }

    @Override
    public List<Feature> map(String tag, List<Feature> features) {
        ArrayList<Feature> hashedFeatures = new ArrayList<Feature>();
        for (Feature feature : features) {
            int bit;
            int hash = MurmurHash3.murmurhash3_x86_32((CharSequence)feature.getName(), (int)0, (int)feature.getName().length(), (int)this.hashSeed);
            int code = (hash >>>= 1) % this.dimension;
            double value = this.preserveValue ? feature.getValue() : ((bit = MurmurHash3.murmurhash3_x86_32((CharSequence)feature.getName(), (int)0, (int)feature.getName().length(), (int)this.valueHashSeed) & 1) == 1 ? 1.0 : -1.0);
            Feature newFeature = new Feature(tag + "-hash=" + code, value);
            hashedFeatures.add(newFeature);
        }
        return hashedFeatures;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FeatureTransformer");
    }
}

