/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.tribuo.data.text.DocumentPreprocessor;

public final class RegexPreprocessor
implements DocumentPreprocessor {
    private List<Pattern> regexes;
    @Config(description="A list of regular expressions in string format used to match the input", mandatory=true)
    private List<String> regexStrings;
    @Config(description="A list of replacement strings which are used to replace the matches", mandatory=true)
    private List<String> replacements;

    private RegexPreprocessor() {
    }

    public RegexPreprocessor(List<String> regexStrings, List<String> replacements) {
        this.replacements = replacements;
        this.regexStrings = regexStrings;
        this.postConfig();
    }

    public void postConfig() {
        if (this.regexStrings.size() != this.replacements.size()) {
            throw new PropertyException("", "regexStrings", String.format("The number of regex strings has to be the same as the number of replacement strings. %s regex string(s) and %s replacement string(s) were provided.", this.regexStrings.size(), this.replacements.size()));
        }
        this.regexes = new ArrayList<Pattern>(this.regexStrings.size());
        for (String regexString : this.regexStrings) {
            this.regexes.add(Pattern.compile(regexString));
        }
    }

    @Override
    public String processDoc(String doc) {
        for (int i = 0; i < this.regexes.size(); ++i) {
            doc = this.regexes.get(i).matcher(doc).replaceAll(this.replacements.get(i));
        }
        return doc;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "DocumentPreprocessor");
    }
}

