/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.text.TextFeatureExtractor;
import org.tribuo.data.text.impl.SimpleTextDataSource;
import org.tribuo.provenance.ConfiguredDataSourceProvenance;

public class SimpleStringDataSource<T extends Output<T>>
extends SimpleTextDataSource<T> {
    private static final Logger logger = Logger.getLogger(SimpleStringDataSource.class.getName());
    @Config(mandatory=true, description="The input data lines.")
    protected List<String> rawLines;

    private SimpleStringDataSource() {
    }

    public SimpleStringDataSource(List<String> rawLines, OutputFactory<T> outputFactory, TextFeatureExtractor<T> extractor) {
        super(outputFactory, extractor);
        this.rawLines = rawLines;
        this.path = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.read();
        this.provenance = this.cacheProvenance();
    }

    @Override
    public void postConfig() {
        this.read();
        this.provenance = this.cacheProvenance();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("(extractor=");
        buffer.append(this.extractor.toString());
        buffer.append(",preprocessors=");
        buffer.append(this.preprocessors.toString());
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    protected void read() {
        int n = 0;
        for (String line : this.rawLines) {
            Optional<Example<Example>> example = this.parseLine(line, ++n);
            example.ifPresent(this.data::add);
        }
    }

    @Override
    protected ConfiguredDataSourceProvenance cacheProvenance() {
        return new SimpleStringDataSourceProvenance(this);
    }

    public static class SimpleStringDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements ConfiguredDataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private final DateTimeProvenance dataSourceCreationTime;
        private final HashProvenance sha256Hash;

        <T extends Output<T>> SimpleStringDataSourceProvenance(SimpleStringDataSource<T> host) {
            super(host, "DataSource");
            this.dataSourceCreationTime = new DateTimeProvenance("datasource-creation-time", OffsetDateTime.now());
            this.sha256Hash = new HashProvenance(DEFAULT_HASH_TYPE, "resource-hash", ProvenanceUtil.hashList((ProvenanceUtil.HashType)DEFAULT_HASH_TYPE, host.rawLines));
        }

        public SimpleStringDataSourceProvenance(Map<String, Provenance> map) {
            this(SimpleStringDataSourceProvenance.extractProvenanceInfo(map));
        }

        private SimpleStringDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
            this.dataSourceCreationTime = (DateTimeProvenance)info.instanceValues.get("datasource-creation-time");
            this.sha256Hash = (HashProvenance)info.instanceValues.get("resource-hash");
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)SimpleStringDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)SimpleStringDataSourceProvenance.class.getSimpleName())).getValue();
            HashMap<String, PrimitiveProvenance> instanceParameters = new HashMap<String, PrimitiveProvenance>();
            instanceParameters.put("datasource-creation-time", (PrimitiveProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"datasource-creation-time", DateTimeProvenance.class, (String)SimpleStringDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("resource-hash", (PrimitiveProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"resource-hash", HashProvenance.class, (String)SimpleStringDataSourceProvenance.class.getSimpleName()));
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleStringDataSourceProvenance)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleStringDataSourceProvenance pairs = (SimpleStringDataSourceProvenance)((Object)o);
            return this.dataSourceCreationTime.equals((Object)pairs.dataSourceCreationTime) && this.sha256Hash.equals((Object)pairs.sha256Hash);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.dataSourceCreationTime, this.sha256Hash);
        }

        public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
            HashMap map = new HashMap();
            map.put("datasource-creation-time", (PrimitiveProvenance<?>)this.dataSourceCreationTime);
            map.put("resource-hash", (PrimitiveProvenance<?>)this.sha256Hash);
            return map;
        }
    }
}

