/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.data.columnar.ColumnarIterator;
import org.tribuo.json.JsonUtil;

public class JsonFileIterator
extends ColumnarIterator
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(JsonFileIterator.class.getName());
    private final JsonParser parser;
    private final Iterator<JsonNode> nodeIterator;
    private int rowNum;

    public JsonFileIterator(Reader reader) {
        block5: {
            this.rowNum = 0;
            JsonFactory jsonFactory = new JsonFactory();
            try {
                this.parser = jsonFactory.createParser(reader);
                this.parser.setCodec((ObjectCodec)new ObjectMapper());
                JsonNode jsonNode = (JsonNode)this.parser.readValueAsTree();
                if (jsonNode.isArray()) {
                    ArrayNode node = (ArrayNode)jsonNode;
                    this.nodeIterator = node.elements();
                    if (this.nodeIterator.hasNext()) {
                        JsonNode curNode = this.nodeIterator.next();
                        if (curNode instanceof ObjectNode) {
                            Map<String, String> curEntry = JsonUtil.convertToMap((ObjectNode)curNode);
                            ArrayList<String> headerList = new ArrayList<String>(curEntry.keySet());
                            Collections.sort(headerList);
                            this.fields = headerList;
                            this.currentRow = Optional.of(new ColumnarIterator.Row((long)this.rowNum, this.fields, curEntry));
                            ++this.rowNum;
                            break block5;
                        }
                        throw new IllegalStateException("Expected an array of JSON objects but found '" + curNode.asText() + "'");
                    }
                    throw new IllegalStateException("No elements found in JSON array");
                }
                throw new IllegalStateException("JSON array not found when reading file");
            }
            catch (IOException e) {
                throw new IllegalStateException("Error reading json file caused by: " + e.getMessage());
            }
        }
    }

    public JsonFileIterator(URI dataFile) throws IOException {
        this(Files.newBufferedReader(Paths.get(dataFile)));
    }

    protected Optional<ColumnarIterator.Row> getRow() {
        if (this.nodeIterator.hasNext()) {
            JsonNode next = this.nodeIterator.next();
            if (next instanceof ObjectNode) {
                ColumnarIterator.Row row = new ColumnarIterator.Row((long)this.rowNum, this.fields, JsonUtil.convertToMap((ObjectNode)next));
                ++this.rowNum;
                return Optional.of(row);
            }
            logger.warning("Unexpected node found, expected ObjectNode, found '" + next.asText() + '\"');
            return Optional.empty();
        }
        try {
            this.parser.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing reader at end of file", e);
        }
        return Optional.empty();
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }
}

