/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public final class JsonUtil {
    private static final Logger logger = Logger.getLogger(JsonUtil.class.getName());

    private JsonUtil() {
    }

    public static Map<String, String> convertToMap(ObjectNode node) {
        if (node != null) {
            HashMap<String, String> entry = new HashMap<String, String>();
            Iterator itr = node.fields();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                if (e.getValue() == null) continue;
                if (((JsonNode)e.getValue()).isValueNode()) {
                    entry.put((String)e.getKey(), ((JsonNode)e.getValue()).asText());
                    continue;
                }
                logger.warning("Ignoring key '" + (String)e.getKey() + "' as it's value '" + ((JsonNode)e.getValue()).asText() + "' is an object or array");
            }
            return entry;
        }
        return Collections.emptyMap();
    }
}

