/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.json;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.config.json.JsonProvenanceSerialization;
import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import com.oracle.labs.mlrg.olcut.util.LabsLogFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.ensemble.EnsembleModel;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.EnsembleModelProvenance;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.provenance.TrainerProvenance;
import org.tribuo.provenance.impl.EmptyDatasetProvenance;
import org.tribuo.provenance.impl.EmptyTrainerProvenance;

public final class StripProvenance {
    private static final Logger logger = Logger.getLogger(StripProvenance.class.getName());

    private StripProvenance() {
    }

    private static ModelProvenance cleanProvenance(ModelProvenance old, String provenanceHash, StripProvenanceOptions opt) {
        OffsetDateTime time;
        HashMap<String, HashProvenance> instanceProvenance;
        Object datasetProvenance = opt.removeProvenances.contains((Object)ProvenanceTypes.ALL) || opt.removeProvenances.contains((Object)ProvenanceTypes.DATASET) ? new EmptyDatasetProvenance() : old.getDatasetProvenance();
        Object trainerProvenance = opt.removeProvenances.contains((Object)ProvenanceTypes.ALL) || opt.removeProvenances.contains((Object)ProvenanceTypes.TRAINER) ? new EmptyTrainerProvenance() : old.getTrainerProvenance();
        if (opt.removeProvenances.contains((Object)ProvenanceTypes.ALL) || opt.removeProvenances.contains((Object)ProvenanceTypes.INSTANCE)) {
            instanceProvenance = new HashMap<String, HashProvenance>();
            time = OffsetDateTime.MIN;
        } else {
            instanceProvenance = new HashMap(old.getInstanceProvenance().getMap());
            time = old.getTrainingTime();
        }
        if (opt.storeHash) {
            logger.info("Writing provenance hash into instance map.");
            instanceProvenance.put("original-provenance-hash", new HashProvenance(opt.hashType, "original-provenance-hash", provenanceHash));
        }
        boolean stripSystem = opt.removeProvenances.contains((Object)ProvenanceTypes.ALL) || opt.removeProvenances.contains((Object)ProvenanceTypes.SYSTEM);
        return new ModelProvenance(old.getClassName(), time, (DatasetProvenance)datasetProvenance, (TrainerProvenance)trainerProvenance, instanceProvenance, !stripSystem);
    }

    private static EnsembleModelProvenance cleanEnsembleProvenance(EnsembleModelProvenance old, ListProvenance<ModelProvenance> memberProvenance, String provenanceHash, StripProvenanceOptions opt) {
        OffsetDateTime time;
        HashMap<String, HashProvenance> instanceProvenance;
        Object datasetProvenance = opt.removeProvenances.contains((Object)ProvenanceTypes.ALL) || opt.removeProvenances.contains((Object)ProvenanceTypes.DATASET) ? new EmptyDatasetProvenance() : old.getDatasetProvenance();
        Object trainerProvenance = opt.removeProvenances.contains((Object)ProvenanceTypes.ALL) || opt.removeProvenances.contains((Object)ProvenanceTypes.TRAINER) ? new EmptyTrainerProvenance() : old.getTrainerProvenance();
        if (opt.removeProvenances.contains((Object)ProvenanceTypes.ALL) || opt.removeProvenances.contains((Object)ProvenanceTypes.INSTANCE)) {
            instanceProvenance = new HashMap<String, HashProvenance>();
            time = OffsetDateTime.MIN;
        } else {
            instanceProvenance = new HashMap(old.getInstanceProvenance().getMap());
            time = old.getTrainingTime();
        }
        if (opt.storeHash) {
            logger.info("Writing provenance hash into instance map.");
            instanceProvenance.put("original-provenance-hash", new HashProvenance(opt.hashType, "original-provenance-hash", provenanceHash));
        }
        return new EnsembleModelProvenance(old.getClassName(), time, (DatasetProvenance)datasetProvenance, (TrainerProvenance)trainerProvenance, instanceProvenance, memberProvenance);
    }

    private static <T extends Output<T>> ModelTuple<T> convertModel(Model<T> oldModel, String provenanceHash, StripProvenanceOptions opt) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (oldModel instanceof EnsembleModel) {
            EnsembleModelProvenance oldProvenance = ((EnsembleModel)oldModel).getProvenance();
            ArrayList<ModelProvenance> newProvenances = new ArrayList<ModelProvenance>();
            ArrayList newModels = new ArrayList();
            for (Model e : ((EnsembleModel)oldModel).getModels()) {
                ModelTuple<T> tuple = StripProvenance.convertModel(e, provenanceHash, opt);
                newProvenances.add(tuple.provenance);
                newModels.add(tuple.model);
            }
            ListProvenance listProv = new ListProvenance(newProvenances);
            EnsembleModelProvenance cleanedProvenance = StripProvenance.cleanEnsembleProvenance(oldProvenance, (ListProvenance<ModelProvenance>)listProv, provenanceHash, opt);
            Class<?> clazz = oldModel.getClass();
            Method copyMethod = clazz.getDeclaredMethod("copy", String.class, ModelProvenance.class, List.class);
            boolean accessible = copyMethod.isAccessible();
            copyMethod.setAccessible(true);
            String newName = oldModel.getName().isEmpty() ? "deprovenanced" : oldModel.getName() + "-deprovenanced";
            EnsembleModel output = (EnsembleModel)copyMethod.invoke(oldModel, newName, cleanedProvenance, newModels);
            copyMethod.setAccessible(accessible);
            return new ModelTuple(output, (ModelProvenance)cleanedProvenance);
        }
        ModelProvenance oldProvenance = oldModel.getProvenance();
        ModelProvenance cleanedProvenance = StripProvenance.cleanProvenance(oldProvenance, provenanceHash, opt);
        Class<?> clazz = oldModel.getClass();
        Method copyMethod = clazz.getDeclaredMethod("copy", String.class, ModelProvenance.class);
        boolean accessible = copyMethod.isAccessible();
        copyMethod.setAccessible(true);
        String newName = oldModel.getName().isEmpty() ? "deprovenanced" : oldModel.getName() + "-deprovenanced";
        Model output = (Model)copyMethod.invoke(oldModel, newName, cleanedProvenance);
        copyMethod.setAccessible(accessible);
        return new ModelTuple(output, cleanedProvenance);
    }

    public static <T extends Output<T>> void main(String[] args) {
        ConfigurationManager cm;
        LabsLogFormatter.setAllLogFormatters();
        StripProvenanceOptions o = new StripProvenanceOptions();
        try {
            cm = new ConfigurationManager(args, (Options)o);
        }
        catch (UsageException e) {
            logger.info(e.getMessage());
            return;
        }
        if (o.inputModel == null || o.outputModel == null) {
            logger.info(cm.usage());
            System.exit(1);
        }
        try {
            Model model;
            logger.info("Loading model from " + o.inputModel);
            if (o.protobuf) {
                model = Model.deserializeFromFile((Path)o.inputModel.toPath());
            } else {
                try (ObjectInputStream ois = IOUtil.getObjectInputStream((File)o.inputModel);){
                    model = (Model)ois.readObject();
                }
            }
            ModelProvenance oldProvenance = model.getProvenance();
            logger.info("Marshalling provenance and creating JSON.");
            JsonProvenanceSerialization jsonProvenanceSerialization = new JsonProvenanceSerialization(true);
            String jsonResult = jsonProvenanceSerialization.marshalAndSerialize((ObjectProvenance)oldProvenance);
            logger.info("Hashing JSON file");
            MessageDigest digest = o.hashType.getDigest();
            byte[] digestBytes = digest.digest(jsonResult.getBytes(StandardCharsets.UTF_8));
            String provenanceHash = ProvenanceUtil.bytesToHexString((byte[])digestBytes);
            logger.info("Provenance hash = " + provenanceHash);
            if (o.provenanceFile != null) {
                logger.info("Writing JSON provenance to " + o.provenanceFile.toString());
                try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(o.provenanceFile), StandardCharsets.UTF_8));){
                    writer.println(jsonResult);
                }
            }
            ModelTuple<T> tuple = StripProvenance.convertModel(model, provenanceHash, o);
            logger.info("Writing model to " + o.outputModel);
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(o.outputModel));){
                oos.writeObject(tuple.model);
            }
            ModelProvenance newProvenance = tuple.provenance;
            logger.info("Marshalling provenance and creating JSON.");
            String newJsonResult = jsonProvenanceSerialization.marshalAndSerialize((ObjectProvenance)newProvenance);
            logger.info("Old provenance = \n" + jsonResult);
            logger.info("New provenance = \n" + newJsonResult);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "Model.copy method missing on a class which extends Model.", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Failed to modify protection on inner copy method on Model.", e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, "Failed to invoke inner copy method on Model.", e);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "Unsupported encoding exception.", e);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to find the input file.", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IO error when reading or writing a file.", e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "The model and/or provenance classes are not on the classpath.", e);
        }
    }

    public static class StripProvenanceOptions
    implements Options {
        @Option(charName=104, longName="store-provenance-hash", usage="Stores a hash of the model provenance in the stripped model.")
        public boolean storeHash;
        @Option(charName=105, longName="input-model-path", usage="The model to load.")
        public File inputModel;
        @Option(charName=111, longName="output-model-path", usage="The location to write out the stripped model.")
        public File outputModel;
        @Option(charName=112, longName="provenance-path", usage="Write out the stripped provenance as json.")
        public File provenanceFile;
        @Option(charName=114, longName="remove-provenances", usage="The provenances to remove")
        public EnumSet<ProvenanceTypes> removeProvenances = EnumSet.noneOf(ProvenanceTypes.class);
        @Option(charName=116, longName="hash-type", usage="The hash type to use.")
        public ProvenanceUtil.HashType hashType = ObjectProvenance.DEFAULT_HASH_TYPE;
        @Option(longName="model-protobuf", usage="Read and write protobuf formatted models.")
        public boolean protobuf;

        public String getOptionsDescription() {
            return "A program for removing Provenance information from a Tribuo Model or SequenceModel.";
        }
    }

    public static enum ProvenanceTypes {
        DATASET,
        TRAINER,
        INSTANCE,
        SYSTEM,
        ALL;

    }

    private static class ModelTuple<T extends Output<T>> {
        public final Model<T> model;
        public final ModelProvenance provenance;

        public ModelTuple(Model<T> model, ModelProvenance provenance) {
            this.model = model;
            this.provenance = provenance;
        }
    }
}

