/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.multilabel.sgd.fm;

import com.oracle.labs.mlrg.olcut.config.Config;
import java.util.logging.Logger;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.common.sgd.AbstractFMTrainer;
import org.tribuo.common.sgd.FMParameters;
import org.tribuo.common.sgd.SGDObjective;
import org.tribuo.math.StochasticGradientOptimiser;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.SparseVector;
import org.tribuo.multilabel.MultiLabel;
import org.tribuo.multilabel.sgd.MultiLabelObjective;
import org.tribuo.multilabel.sgd.fm.FMMultiLabelModel;
import org.tribuo.multilabel.sgd.objectives.BinaryCrossEntropy;
import org.tribuo.provenance.ModelProvenance;

public class FMMultiLabelTrainer
extends AbstractFMTrainer<MultiLabel, SGDVector, FMMultiLabelModel> {
    private static final Logger logger = Logger.getLogger(FMMultiLabelTrainer.class.getName());
    @Config(description="The classification objective function to use.")
    private MultiLabelObjective objective = new BinaryCrossEntropy();

    public FMMultiLabelTrainer(MultiLabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, int minibatchSize, long seed, int factorizedDimSize, double variance) {
        super(optimiser, epochs, loggingInterval, minibatchSize, seed, factorizedDimSize, variance);
        this.objective = objective;
    }

    public FMMultiLabelTrainer(MultiLabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, long seed, int factorizedDimSize, double variance) {
        this(objective, optimiser, epochs, loggingInterval, 1, seed, factorizedDimSize, variance);
    }

    public FMMultiLabelTrainer(MultiLabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, long seed, int factorizedDimSize, double variance) {
        this(objective, optimiser, epochs, 1000, 1, seed, factorizedDimSize, variance);
    }

    private FMMultiLabelTrainer() {
    }

    protected SparseVector getTarget(ImmutableOutputInfo<MultiLabel> outputInfo, MultiLabel output) {
        return output.convertToSparseVector(outputInfo);
    }

    protected SGDObjective<SGDVector> getObjective() {
        return this.objective;
    }

    protected FMMultiLabelModel createModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureMap, ImmutableOutputInfo<MultiLabel> outputInfo, FMParameters parameters) {
        return new FMMultiLabelModel(name, provenance, featureMap, outputInfo, parameters, this.objective.getNormalizer(), this.objective.isProbabilistic(), this.objective.threshold());
    }

    protected String getModelClassName() {
        return FMMultiLabelModel.class.getName();
    }

    public String toString() {
        return "FMMultiLabelTrainer(objective=" + this.objective.toString() + ",optimiser=" + this.optimiser.toString() + ",epochs=" + this.epochs + ",minibatchSize=" + this.minibatchSize + ",seed=" + this.seed + ",factorizedDimSize=" + this.factorizedDimSize + ",variance=" + this.variance + ")";
    }
}

