/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.multilabel.sgd.linear;

import com.oracle.labs.mlrg.olcut.config.ArgumentException;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import java.util.logging.Logger;
import org.tribuo.math.optimisers.GradientOptimiserOptions;
import org.tribuo.multilabel.sgd.MultiLabelObjective;
import org.tribuo.multilabel.sgd.linear.LinearSGDTrainer;
import org.tribuo.multilabel.sgd.objectives.BinaryCrossEntropy;
import org.tribuo.multilabel.sgd.objectives.Hinge;

public class LinearSGDOptions
implements Options {
    private static final Logger logger = Logger.getLogger(LinearSGDOptions.class.getName());
    public GradientOptimiserOptions sgoOptions;
    @Option(longName="sgd-epochs", usage="Number of SGD epochs.")
    public int sgdEpochs = 5;
    @Option(longName="sgd-objective", usage="Loss function.")
    public LossEnum sgdObjective = LossEnum.SIGMOID;
    @Option(longName="sgd-logging-interval", usage="Log the objective after <int> examples.")
    public int sgdLoggingInterval = 100;
    @Option(longName="sgd-minibatch-size", usage="Minibatch size.")
    public int sgdMinibatchSize = 1;
    @Option(longName="sgd-seed", usage="Sets the random seed for the LinearSGDTrainer.")
    public long sgdSeed = 12345L;

    public MultiLabelObjective getLoss() {
        switch (this.sgdObjective) {
            case HINGE: {
                return new Hinge();
            }
            case SIGMOID: {
                return new BinaryCrossEntropy();
            }
        }
        throw new ArgumentException("sgd-objective", "Unknown loss function " + (Object)((Object)this.sgdObjective));
    }

    public LinearSGDTrainer getTrainer() {
        logger.info(String.format("Set logging interval to %d", this.sgdLoggingInterval));
        return new LinearSGDTrainer(this.getLoss(), this.sgoOptions.getOptimiser(), this.sgdEpochs, this.sgdLoggingInterval, this.sgdMinibatchSize, this.sgdSeed);
    }

    public static enum LossEnum {
        HINGE,
        SIGMOID;

    }
}

