/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.multilabel.sgd.linear;

import com.oracle.labs.mlrg.olcut.config.Config;
import java.util.logging.Logger;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.common.sgd.AbstractLinearSGDTrainer;
import org.tribuo.common.sgd.SGDObjective;
import org.tribuo.math.LinearParameters;
import org.tribuo.math.StochasticGradientOptimiser;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.SparseVector;
import org.tribuo.multilabel.MultiLabel;
import org.tribuo.multilabel.sgd.MultiLabelObjective;
import org.tribuo.multilabel.sgd.linear.LinearSGDModel;
import org.tribuo.multilabel.sgd.objectives.BinaryCrossEntropy;
import org.tribuo.provenance.ModelProvenance;

public class LinearSGDTrainer
extends AbstractLinearSGDTrainer<MultiLabel, SGDVector, LinearSGDModel> {
    private static final Logger logger = Logger.getLogger(LinearSGDTrainer.class.getName());
    @Config(description="The classification objective function to use.")
    private MultiLabelObjective objective = new BinaryCrossEntropy();

    public LinearSGDTrainer(MultiLabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, int minibatchSize, long seed) {
        super(optimiser, epochs, loggingInterval, minibatchSize, seed);
        this.objective = objective;
    }

    public LinearSGDTrainer(MultiLabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, long seed) {
        this(objective, optimiser, epochs, loggingInterval, 1, seed);
    }

    public LinearSGDTrainer(MultiLabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, long seed) {
        this(objective, optimiser, epochs, 1000, 1, seed);
    }

    private LinearSGDTrainer() {
    }

    protected SparseVector getTarget(ImmutableOutputInfo<MultiLabel> outputInfo, MultiLabel output) {
        return output.convertToSparseVector(outputInfo);
    }

    protected SGDObjective<SGDVector> getObjective() {
        return this.objective;
    }

    protected LinearSGDModel createModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureMap, ImmutableOutputInfo<MultiLabel> outputInfo, LinearParameters parameters) {
        return new LinearSGDModel(name, provenance, featureMap, outputInfo, parameters, this.objective.getNormalizer(), this.objective.isProbabilistic(), this.objective.threshold());
    }

    protected String getModelClassName() {
        return LinearSGDModel.class.getName();
    }

    public String toString() {
        return "LinearSGDTrainer(objective=" + this.objective.toString() + ",optimiser=" + this.optimiser.toString() + ",epochs=" + this.epochs + ",minibatchSize=" + this.minibatchSize + ",seed=" + this.seed + ")";
    }
}

