/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.liblinear;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import de.bwaldvogel.liblinear.SolverType;
import java.io.Serializable;
import org.tribuo.common.liblinear.LibLinearType;
import org.tribuo.regression.Regressor;

public final class LinearRegressionType
implements LibLinearType<Regressor> {
    private static final long serialVersionUID = 1L;
    @Config(description="The type of regression algorithm.", mandatory=true)
    private LinearType type;

    private LinearRegressionType() {
    }

    public LinearRegressionType(LinearType type) {
        this.type = type;
    }

    public boolean isClassification() {
        return false;
    }

    public boolean isRegression() {
        return true;
    }

    public boolean isAnomaly() {
        return false;
    }

    public SolverType getSolverType() {
        return this.type.getSolverType();
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "LibLinearType");
    }

    public static enum LinearType implements Serializable
    {
        L2R_L2LOSS_SVR(SolverType.L2R_L2LOSS_SVR),
        L2R_L2LOSS_SVR_DUAL(SolverType.L2R_L2LOSS_SVR_DUAL),
        L2R_L1LOSS_SVR_DUAL(SolverType.L2R_L1LOSS_SVR_DUAL);

        private final SolverType type;

        private LinearType(SolverType type) {
            this.type = type;
        }

        public SolverType getSolverType() {
            return this.type;
        }
    }
}

