/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.liblinear;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.util.LabsLogFormatter;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.IOException;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Model;
import org.tribuo.OutputFactory;
import org.tribuo.data.DataOptions;
import org.tribuo.regression.RegressionFactory;
import org.tribuo.regression.evaluation.RegressionEvaluation;
import org.tribuo.regression.liblinear.LibLinearRegressionTrainer;
import org.tribuo.regression.liblinear.LinearRegressionType;
import org.tribuo.util.Util;

public class TrainTest {
    private static final Logger logger = Logger.getLogger(TrainTest.class.getName());

    public static void main(String[] args) throws IOException {
        ConfigurationManager cm;
        LabsLogFormatter.setAllLogFormatters();
        LibLinearOptions o = new LibLinearOptions();
        try {
            cm = new ConfigurationManager(args, (Options)o);
        }
        catch (UsageException e) {
            logger.info(e.getMessage());
            return;
        }
        if (o.general.trainingPath == null || o.general.testingPath == null) {
            logger.info(cm.usage());
            return;
        }
        RegressionFactory factory = new RegressionFactory();
        Pair data = o.general.load((OutputFactory)factory);
        Dataset train = (Dataset)data.getA();
        Dataset test = (Dataset)data.getB();
        LibLinearRegressionTrainer trainer = new LibLinearRegressionTrainer(new LinearRegressionType(o.algorithm), o.cost, o.maxIterations, o.terminationCriterion, o.epsilon);
        logger.info("Training using " + ((Object)((Object)trainer)).toString());
        long trainStart = System.currentTimeMillis();
        Model model = trainer.train(train);
        long trainStop = System.currentTimeMillis();
        logger.info("Finished training regressor " + Util.formatDuration((long)trainStart, (long)trainStop));
        long testStart = System.currentTimeMillis();
        RegressionEvaluation evaluation = (RegressionEvaluation)factory.getEvaluator().evaluate(model, test);
        long testStop = System.currentTimeMillis();
        logger.info("Finished evaluating model " + Util.formatDuration((long)testStart, (long)testStop));
        System.out.println(evaluation.toString());
        if (o.general.outputPath != null) {
            o.general.saveModel(model);
        }
    }

    public static class LibLinearOptions
    implements Options {
        public DataOptions general;
        @Option(charName=112, longName="cost-penalty", usage="Cost penalty for SVM.")
        public double cost = 1.0;
        @Option(longName="max-iterations", usage="Max iterations over the data.")
        public int maxIterations = 1000;
        @Option(longName="epsilon-insensitivity", usage="Regression value insensitivity for margin.")
        public double epsilon = 0.1;
        @Option(charName=101, longName="termination-criterion", usage="Tolerance of the optimization termination criterion.")
        public double terminationCriterion = 0.01;
        @Option(charName=116, longName="algorithm", usage="Type of SVR.")
        public LinearRegressionType.LinearType algorithm = LinearRegressionType.LinearType.L2R_L2LOSS_SVR;

        public String getOptionsDescription() {
            return "Trains and tests a LibLinear regression model on the specified datasets.";
        }
    }
}

