/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.sgd.linear;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.ONNXExportable;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.common.sgd.AbstractLinearSGDModel;
import org.tribuo.common.sgd.AbstractSGDModel;
import org.tribuo.impl.ModelDataCarrier;
import org.tribuo.math.LinearParameters;
import org.tribuo.math.Parameters;
import org.tribuo.math.la.DenseMatrix;
import org.tribuo.math.protos.ParametersProto;
import org.tribuo.protos.core.ModelDataProto;
import org.tribuo.protos.core.ModelProto;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.regression.Regressor;
import org.tribuo.regression.sgd.protos.RegressionLinearSGDProto;
import org.tribuo.util.onnx.ONNXNode;

public class LinearSGDModel
extends AbstractLinearSGDModel<Regressor>
implements ONNXExportable {
    private static final long serialVersionUID = 3L;
    public static final int CURRENT_VERSION = 0;
    private final String[] dimensionNames;
    @Deprecated
    private DenseMatrix weights = null;

    LinearSGDModel(String name, String[] dimensionNames, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Regressor> outputIDInfo, LinearParameters parameters) {
        super(name, provenance, featureIDMap, outputIDInfo, parameters, false);
        this.dimensionNames = dimensionNames;
    }

    public static LinearSGDModel deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        RegressionLinearSGDProto proto = (RegressionLinearSGDProto)message.unpack(RegressionLinearSGDProto.class);
        ModelDataCarrier carrier = ModelDataCarrier.deserialize((ModelDataProto)proto.getMetadata());
        if (!carrier.outputDomain().getOutput(0).getClass().equals(Regressor.class)) {
            throw new IllegalStateException("Invalid protobuf, output domain is not a regression domain, found " + carrier.outputDomain().getClass());
        }
        ImmutableOutputInfo outputDomain = carrier.outputDomain();
        Parameters params = Parameters.deserialize((ParametersProto)proto.getParams());
        if (!(params instanceof LinearParameters)) {
            throw new IllegalStateException("Invalid protobuf, parameters must be LinearParameters, found " + params.getClass());
        }
        String[] dimensionNames = (String[])proto.getDimensionNamesList().toArray((Object[])new String[0]);
        if (dimensionNames.length != outputDomain.size()) {
            throw new IllegalStateException("Invalid protobuf, found a different number of dimension names to the output dimensions, found " + dimensionNames.length + " , expected " + outputDomain.size());
        }
        return new LinearSGDModel(carrier.name(), dimensionNames, carrier.provenance(), carrier.featureDomain(), (ImmutableOutputInfo<Regressor>)outputDomain, (LinearParameters)params);
    }

    public Prediction<Regressor> predict(Example<Regressor> example) {
        AbstractSGDModel.PredAndActive predTuple = this.predictSingle(example);
        return new Prediction((Output)new Regressor(this.dimensionNames, predTuple.prediction.toArray()), predTuple.numActiveFeatures - 1, example);
    }

    public ModelProto serialize() {
        ModelDataCarrier carrier = this.createDataCarrier();
        RegressionLinearSGDProto.Builder modelBuilder = RegressionLinearSGDProto.newBuilder();
        modelBuilder.setMetadata(carrier.serialize());
        modelBuilder.setParams((ParametersProto)this.modelParameters.serialize());
        modelBuilder.addAllDimensionNames(Arrays.asList(this.dimensionNames));
        ModelProto.Builder builder = ModelProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(LinearSGDModel.class.getName());
        builder.setSerializedData(Any.pack((Message)modelBuilder.build()));
        return builder.build();
    }

    protected LinearSGDModel copy(String newName, ModelProvenance newProvenance) {
        return new LinearSGDModel(newName, Arrays.copyOf(this.dimensionNames, this.dimensionNames.length), newProvenance, this.featureIDMap, (ImmutableOutputInfo<Regressor>)this.outputIDInfo, (LinearParameters)this.modelParameters.copy());
    }

    protected String getDimensionName(int index) {
        return this.dimensionNames[index];
    }

    protected ONNXNode onnxOutput(ONNXNode input) {
        return input;
    }

    protected String onnxModelName() {
        return "Regression-LinearSGDModel";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.weights != null && this.modelParameters == null) {
            this.modelParameters = new LinearParameters(this.weights);
            this.weights = null;
            this.addBias = true;
        }
    }
}

