/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.rtree.impl;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.Arrays;
import org.tribuo.common.tree.impl.IntArrayContainer;

public class InvertedFeature
implements Comparable<InvertedFeature> {
    private static final int DEFAULT_SIZE = 8;
    public final double value;
    private int[] indices = null;
    private int curSize = -1;
    private int index;

    public InvertedFeature(double value, int[] indices) {
        this.value = value;
        this.indices = indices;
        this.curSize = indices.length;
    }

    public InvertedFeature(double value, int index) {
        this.value = value;
        this.index = index;
    }

    private InvertedFeature(InvertedFeature other) {
        this.value = other.value;
        this.curSize = other.curSize;
        this.index = other.index;
        this.indices = (int[])(other.indices != null ? Arrays.copyOf(other.indices, other.indices.length) : null);
    }

    public void add(int index) {
        if (this.indices == null) {
            this.initArrays();
        }
        this.append(index);
    }

    private void append(int index) {
        if (this.curSize == this.indices.length) {
            int newSize = this.indices.length + (this.indices.length >> 1);
            this.indices = Arrays.copyOf(this.indices, newSize);
        }
        this.indices[this.curSize] = index;
        ++this.curSize;
    }

    public int[] indices() {
        if (this.indices != null) {
            return this.indices;
        }
        int[] ret = new int[]{this.index};
        return ret;
    }

    public void fixSize() {
        if (this.indices != null) {
            this.indices = Arrays.copyOf(this.indices, this.curSize);
        }
    }

    public Pair<InvertedFeature, InvertedFeature> split(IntArrayContainer allLeftIndices, IntArrayContainer buffer) {
        int[] allLeftArray = allLeftIndices.array;
        int allLeftSize = allLeftIndices.size;
        int[] bufferArray = buffer.array;
        if (this.indices != null) {
            int[] leftIndices = new int[this.indices.length];
            int leftSize = 0;
            int[] rightIndices = new int[this.indices.length];
            int rightSize = 0;
            int bufferIdx = 0;
            int curIndex = 0;
            int j = 0;
            for (int i = 0; i < this.curSize; ++i) {
                while (j < allLeftSize && (curIndex = allLeftArray[j]) < this.indices[i]) {
                    bufferArray[bufferIdx] = curIndex;
                    ++bufferIdx;
                    ++j;
                }
                if (j < allLeftSize && allLeftArray[j] == this.indices[i]) {
                    leftIndices[leftSize] = this.indices[i];
                    ++leftSize;
                    ++j;
                    continue;
                }
                rightIndices[rightSize] = this.indices[i];
                ++rightSize;
            }
            if (j < allLeftSize) {
                System.arraycopy(allLeftArray, j, bufferArray, bufferIdx, allLeftSize - j);
            }
            buffer.size = bufferIdx + (allLeftSize - j);
            allLeftIndices.size = 0;
            InvertedFeature left = leftSize == 0 ? null : (leftSize == 1 ? new InvertedFeature(this.value, leftIndices[0]) : new InvertedFeature(this.value, Arrays.copyOf(leftIndices, leftSize)));
            InvertedFeature right = rightSize == 0 ? null : (rightSize == 1 ? new InvertedFeature(this.value, rightIndices[0]) : new InvertedFeature(this.value, Arrays.copyOf(rightIndices, rightSize)));
            return new Pair((Object)left, right);
        }
        boolean found = false;
        int i = 0;
        while (!found && i < allLeftSize) {
            if (allLeftArray[i] == this.index) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            System.arraycopy(allLeftArray, 0, bufferArray, 0, i);
            ++i;
            while (i < allLeftSize) {
                bufferArray[i - 1] = allLeftArray[i];
                ++i;
            }
            if (i < allLeftSize - 1) {
                System.arraycopy(allLeftArray, i + 1, bufferArray, i, allLeftSize - i);
            }
            buffer.size = allLeftSize - 1;
            allLeftIndices.size = 0;
            return new Pair((Object)new InvertedFeature(this.value, this.index), null);
        }
        allLeftIndices.array = bufferArray;
        allLeftIndices.size = 0;
        buffer.array = allLeftArray;
        buffer.size = allLeftSize;
        return new Pair(null, (Object)new InvertedFeature(this.value, this.index));
    }

    private void initArrays() {
        this.indices = new int[8];
        this.indices[0] = this.index;
        this.curSize = 1;
    }

    @Override
    public int compareTo(InvertedFeature o) {
        return Double.compare(this.value, o.value);
    }

    public String toString() {
        if (this.indices != null) {
            return "InvertedFeature(value=" + this.value + ",size=" + this.curSize + ",indices=" + Arrays.toString(this.indices) + ")";
        }
        return "InvertedFeature(value=" + this.value + ",size=" + this.curSize + ",index=" + this.index + ")";
    }

    public InvertedFeature deepCopy() {
        return new InvertedFeature(this);
    }
}

