/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.rtree.impl;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tribuo.common.tree.impl.IntArrayContainer;
import org.tribuo.regression.rtree.impl.InvertedFeature;

public class TreeFeature
implements Iterable<InvertedFeature> {
    private final int id;
    private final List<InvertedFeature> feature;
    private final Map<Double, InvertedFeature> valueMap;
    private boolean sorted = true;

    public TreeFeature(int id) {
        this.id = id;
        this.feature = new ArrayList<InvertedFeature>();
        this.valueMap = new HashMap<Double, InvertedFeature>();
    }

    private TreeFeature(int id, List<InvertedFeature> data) {
        this.id = id;
        this.feature = data;
        this.valueMap = null;
    }

    private TreeFeature(int id, List<InvertedFeature> data, Map<Double, InvertedFeature> valueMap, boolean sorted) {
        this.id = id;
        this.feature = data;
        this.valueMap = valueMap;
        this.sorted = sorted;
    }

    @Override
    public Iterator<InvertedFeature> iterator() {
        return this.feature.iterator();
    }

    public List<InvertedFeature> getFeature() {
        return this.feature;
    }

    public void observeValue(double value, int exampleID) {
        Double dValue = value;
        InvertedFeature f = this.valueMap.get(dValue);
        if (f == null) {
            f = new InvertedFeature(value, exampleID);
            this.valueMap.put(dValue, f);
            this.feature.add(f);
            this.sorted = false;
        } else {
            f.add(exampleID);
        }
    }

    public void sort() {
        this.feature.sort(null);
        this.sorted = true;
    }

    public void fixSize() {
        this.feature.forEach(InvertedFeature::fixSize);
    }

    public Pair<TreeFeature, TreeFeature> split(int[] leftIndices, int[] rightIndices, IntArrayContainer firstBuffer, IntArrayContainer secondBuffer) {
        List<Object> rightFeatures;
        ArrayList<InvertedFeature> leftFeatures;
        if (!this.sorted) {
            throw new IllegalStateException("TreeFeature must be sorted before split is called");
        }
        if (this.feature.size() == 1) {
            double value = this.feature.get((int)0).value;
            leftFeatures = Collections.singletonList(new InvertedFeature(value, leftIndices));
            rightFeatures = Collections.singletonList(new InvertedFeature(value, rightIndices));
        } else {
            leftFeatures = new ArrayList();
            rightFeatures = new ArrayList();
            firstBuffer.fill(leftIndices);
            for (InvertedFeature f : this.feature) {
                if (firstBuffer.size > 0) {
                    Pair<InvertedFeature, InvertedFeature> split = f.split(firstBuffer, secondBuffer);
                    IntArrayContainer tmp = secondBuffer;
                    secondBuffer = firstBuffer;
                    firstBuffer = tmp;
                    InvertedFeature left = (InvertedFeature)split.getA();
                    InvertedFeature right = (InvertedFeature)split.getB();
                    if (left != null) {
                        leftFeatures.add(left);
                    }
                    if (right == null) continue;
                    rightFeatures.add(right);
                    continue;
                }
                rightFeatures.add(f);
            }
        }
        return new Pair((Object)new TreeFeature(this.id, leftFeatures), (Object)new TreeFeature(this.id, rightFeatures));
    }

    public String toString() {
        return "TreeFeature(id=" + this.id + ",values=" + this.feature.toString() + ")";
    }

    public TreeFeature deepCopy() {
        HashMap<Double, InvertedFeature> newValueMap;
        ArrayList<InvertedFeature> newFeature = new ArrayList<InvertedFeature>();
        if (this.valueMap != null) {
            newValueMap = new HashMap<Double, InvertedFeature>();
            for (Map.Entry<Double, InvertedFeature> e : this.valueMap.entrySet()) {
                InvertedFeature featureCopy = e.getValue().deepCopy();
                newValueMap.put(e.getKey(), featureCopy);
                newFeature.add(featureCopy);
                newFeature.sort(null);
            }
        } else {
            newValueMap = null;
            for (InvertedFeature f : this.feature) {
                newFeature.add(f.deepCopy());
            }
        }
        return new TreeFeature(this.id, newFeature, newValueMap, true);
    }
}

