/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.xgboost;

import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import org.tribuo.regression.xgboost.XGBoostRegressionTrainer;

public class XGBoostOptions
implements Options {
    @Option(longName="xgb-regression-metric", usage="Regression type to use. Defaults to LINEAR.")
    public XGBoostRegressionTrainer.RegressionType rType = XGBoostRegressionTrainer.RegressionType.LINEAR;
    @Option(longName="xgb-ensemble-size", usage="Number of trees in the ensemble.")
    public int ensembleSize = -1;
    @Option(longName="xgb-alpha", usage="L1 regularization term for weights (default 0).")
    public float alpha = 0.0f;
    @Option(longName="xgb-min-weight", usage="Minimum sum of instance weights needed in a leaf (default 1, range [0,inf]).")
    public float minWeight = 1.0f;
    @Option(longName="xgb-max-depth", usage="Max tree depth (default 6, range (0,inf]).")
    public int depth = 6;
    @Option(longName="xgb-eta", usage="Step size shrinkage parameter (default 0.3, range [0,1]).")
    public float eta = 0.3f;
    @Option(longName="xgb-subsample-features", usage="Subsample features for each tree (default 1, range (0,1]).")
    public float subsampleFeatures;
    @Option(longName="xgb-gamma", usage="Minimum loss reduction to make a split (default 0, range [0,inf]).")
    public float gamma = 0.0f;
    @Option(longName="xgb-lambda", usage="L2 regularization term for weights (default 1).")
    public float lambda = 1.0f;
    @Option(longName="xgb-quiet", usage="Make the XGBoost training procedure quiet.")
    public boolean quiet;
    @Option(longName="xgb-subsample", usage="Subsample size for each tree (default 1, range (0,1]).")
    public float subsample = 1.0f;
    @Option(longName="xgb-num-threads", usage="Number of threads to use (default 4, range (1, num hw threads)).")
    public int numThreads;
    @Option(longName="xgb-seed", usage="Sets the random seed for XGBoost.")
    private long seed = 12345L;

    public XGBoostRegressionTrainer getTrainer() {
        return new XGBoostRegressionTrainer(this.rType, this.ensembleSize, this.eta, this.gamma, this.depth, this.minWeight, this.subsample, this.subsampleFeatures, this.lambda, this.alpha, this.numThreads, this.quiet, this.seed);
    }
}

