/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.xgboost;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.tribuo.Example;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.common.xgboost.XGBoostOutputConverter;
import org.tribuo.common.xgboost.protos.XGBoostOutputConverterProto;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.regression.Regressor;

@ProtoSerializableClass(version=0)
public final class XGBoostRegressionConverter
implements XGBoostOutputConverter<Regressor> {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;

    public static XGBoostRegressionConverter deserializeFromProto(int version, String className, Any message) {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        if (message.getValue() != ByteString.EMPTY) {
            throw new IllegalArgumentException("Invalid proto");
        }
        return new XGBoostRegressionConverter();
    }

    public boolean generatesProbabilities() {
        return false;
    }

    public Prediction<Regressor> convertOutput(ImmutableOutputInfo<Regressor> info, List<float[]> probabilities, int numValidFeatures, Example<Regressor> example) {
        Regressor.DimensionTuple[] tuples = new Regressor.DimensionTuple[probabilities.size()];
        int i = 0;
        for (float[] f : probabilities) {
            tuples[i] = new Regressor.DimensionTuple(((Regressor)info.getOutput(i)).getNames()[0], (double)f[0]);
            ++i;
        }
        return new Prediction((Output)new Regressor(tuples), numValidFeatures, example);
    }

    public List<Prediction<Regressor>> convertBatchOutput(ImmutableOutputInfo<Regressor> info, List<float[][]> probabilities, int[] numValidFeatures, Example<Regressor>[] examples) {
        if (numValidFeatures.length != examples.length || probabilities.get(0).length != numValidFeatures.length) {
            throw new IllegalArgumentException("Lengths not the same, numValidFeatures.length = " + numValidFeatures.length + ", examples.length = " + examples.length + ", probabilities.get(0).length = " + probabilities.get(0).length);
        }
        Regressor.DimensionTuple[][] tuples = new Regressor.DimensionTuple[numValidFeatures.length][probabilities.size()];
        for (int i = 0; i < probabilities.size(); ++i) {
            float[][] f = probabilities.get(i);
            String curName = ((Regressor)info.getOutput(i)).getNames()[0];
            for (int j = 0; j < numValidFeatures.length; ++j) {
                tuples[j][i] = new Regressor.DimensionTuple(curName, (double)f[j][0]);
            }
        }
        ArrayList<Prediction<Regressor>> predictions = new ArrayList<Prediction<Regressor>>();
        for (int i = 0; i < numValidFeatures.length; ++i) {
            predictions.add((Prediction<Regressor>)new Prediction((Output)new Regressor(tuples[i]), numValidFeatures[i], examples[i]));
        }
        return predictions;
    }

    public XGBoostOutputConverterProto serialize() {
        return (XGBoostOutputConverterProto)ProtoUtil.serialize((ProtoSerializable)this);
    }

    public Class<Regressor> getTypeWitness() {
        return Regressor.class;
    }
}

