/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.interop.tensorflow;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tensorflow.Graph;
import org.tensorflow.Session;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.proto.framework.GraphDef;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.impl.ModelDataCarrier;
import org.tribuo.interop.tensorflow.FeatureConverter;
import org.tribuo.interop.tensorflow.OutputConverter;
import org.tribuo.interop.tensorflow.TensorFlowModel;
import org.tribuo.interop.tensorflow.TensorFlowNativeModel;
import org.tribuo.interop.tensorflow.TensorFlowUtil;
import org.tribuo.interop.tensorflow.protos.FeatureConverterProto;
import org.tribuo.interop.tensorflow.protos.OutputConverterProto;
import org.tribuo.interop.tensorflow.protos.TensorFlowCheckpointModelProto;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.ModelDataProto;
import org.tribuo.protos.core.ModelProto;
import org.tribuo.provenance.ModelProvenance;

public final class TensorFlowCheckpointModel<T extends Output<T>>
extends TensorFlowModel<T>
implements Closeable {
    private static final Logger logger = Logger.getLogger(TensorFlowCheckpointModel.class.getName());
    private static final long serialVersionUID = 200L;
    public static final int CURRENT_VERSION = 0;
    private String checkpointDirectory;
    private String checkpointName;
    private boolean initialized;

    TensorFlowCheckpointModel(String name, ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDMap, GraphDef graphDef, String checkpointDirectory, String checkpointName, int batchSize, String outputName, FeatureConverter featureConverter, OutputConverter<T> outputConverter) {
        super(name, description, featureIDMap, outputIDMap, graphDef, batchSize, outputName, featureConverter, outputConverter);
        this.checkpointDirectory = checkpointDirectory;
        this.checkpointName = checkpointName;
        try {
            this.session.restore(this.resolvePath());
            this.initialized = true;
        }
        catch (TensorFlowException e) {
            logger.log(Level.WARNING, "Failed to initialise model in directory " + checkpointDirectory, e);
        }
    }

    public static TensorFlowCheckpointModel<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        TensorFlowCheckpointModelProto proto = (TensorFlowCheckpointModelProto)message.unpack(TensorFlowCheckpointModelProto.class);
        OutputConverter outputConverter = (OutputConverter)ProtoUtil.deserialize((Message)proto.getOutputConverter());
        FeatureConverter featureConverter = (FeatureConverter)ProtoUtil.deserialize((Message)proto.getFeatureConverter());
        ModelDataCarrier carrier = ModelDataCarrier.deserialize((ModelDataProto)proto.getMetadata());
        if (!carrier.outputDomain().getOutput(0).getClass().equals(outputConverter.getTypeWitness())) {
            throw new IllegalStateException("Invalid protobuf, output domain does not match converter, found " + carrier.outputDomain().getClass() + " and " + outputConverter.getTypeWitness());
        }
        GraphDef graphDef = GraphDef.parseFrom((ByteString)proto.getModelDef());
        return new TensorFlowCheckpointModel(carrier.name(), carrier.provenance(), carrier.featureDomain(), carrier.outputDomain(), graphDef, proto.getCheckpointDirectory(), proto.getCheckpointName(), proto.getBatchSize(), proto.getOutputName(), featureConverter, outputConverter);
    }

    private final String resolvePath() {
        return Paths.get(this.checkpointDirectory, this.checkpointName).toString();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public final void initialize() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        this.session = new Session(this.modelGraph);
        this.session.restore(this.resolvePath());
        this.initialized = true;
    }

    public void setCheckpointDirectory(String newCheckpointDirectory) {
        this.checkpointDirectory = newCheckpointDirectory;
    }

    public String getCheckpointDirectory() {
        return this.checkpointDirectory;
    }

    public void setCheckpointName(String newCheckpointName) {
        this.checkpointName = newCheckpointName;
    }

    public String getCheckpointName() {
        return this.checkpointName;
    }

    public TensorFlowNativeModel<T> convertToNativeModel() {
        Map<String, TensorFlowUtil.TensorTuple> tensorMap = TensorFlowUtil.extractMarshalledVariables(this.modelGraph, this.session);
        return new TensorFlowNativeModel(this.name, this.provenance, this.featureIDMap, this.outputIDInfo, this.modelGraph.toGraphDef(), tensorMap, this.batchSize, this.outputName, this.featureConverter, this.outputConverter);
    }

    protected TensorFlowCheckpointModel<T> copy(String newName, ModelProvenance newProvenance) {
        return new TensorFlowCheckpointModel<T>(newName, newProvenance, this.featureIDMap, this.outputIDInfo, this.modelGraph.toGraphDef(), this.checkpointDirectory, this.checkpointName, this.batchSize, this.outputName, this.featureConverter, this.outputConverter);
    }

    public ModelProto serialize() {
        ModelDataCarrier carrier = this.createDataCarrier();
        TensorFlowCheckpointModelProto.Builder modelBuilder = TensorFlowCheckpointModelProto.newBuilder();
        modelBuilder.setMetadata(carrier.serialize());
        modelBuilder.setModelDef(ByteString.copyFrom((byte[])this.modelGraph.toGraphDef().toByteArray()));
        modelBuilder.setOutputName(this.outputName);
        modelBuilder.setBatchSize(this.batchSize);
        modelBuilder.setCheckpointDirectory(this.checkpointDirectory);
        modelBuilder.setCheckpointName(this.checkpointName);
        modelBuilder.setOutputConverter((OutputConverterProto)this.outputConverter.serialize());
        modelBuilder.setFeatureConverter((FeatureConverterProto)this.featureConverter.serialize());
        ModelProto.Builder builder = ModelProto.newBuilder();
        builder.setSerializedData(Any.pack((Message)modelBuilder.build()));
        builder.setClassName(TensorFlowCheckpointModel.class.getName());
        builder.setVersion(0);
        return builder.build();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Can't serialize a closed model, the state has gone.");
        }
        out.defaultWriteObject();
        byte[] modelBytes = this.modelGraph.toGraphDef().toByteArray();
        out.writeObject(modelBytes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] modelBytes = (byte[])in.readObject();
        this.modelGraph = new Graph();
        this.modelGraph.importGraphDef(GraphDef.parseFrom((byte[])modelBytes));
        this.session = new Session(this.modelGraph);
        try {
            this.session.restore(this.resolvePath());
            this.initialized = true;
        }
        catch (TensorFlowException e) {
            logger.log(Level.WARNING, "Failed to initialise model after deserialization, attempted to load from " + this.checkpointDirectory, e);
        }
    }
}

