/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.interop.tensorflow;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.tensorflow.Graph;
import org.tensorflow.Session;
import org.tensorflow.proto.framework.GraphDef;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.impl.ModelDataCarrier;
import org.tribuo.interop.tensorflow.FeatureConverter;
import org.tribuo.interop.tensorflow.OutputConverter;
import org.tribuo.interop.tensorflow.TensorFlowCheckpointModel;
import org.tribuo.interop.tensorflow.TensorFlowModel;
import org.tribuo.interop.tensorflow.TensorFlowUtil;
import org.tribuo.interop.tensorflow.protos.FeatureConverterProto;
import org.tribuo.interop.tensorflow.protos.OutputConverterProto;
import org.tribuo.interop.tensorflow.protos.TensorFlowNativeModelProto;
import org.tribuo.interop.tensorflow.protos.TensorTupleProto;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.ModelDataProto;
import org.tribuo.protos.core.ModelProto;
import org.tribuo.provenance.ModelProvenance;

public final class TensorFlowNativeModel<T extends Output<T>>
extends TensorFlowModel<T> {
    private static final long serialVersionUID = 200L;
    public static final int CURRENT_VERSION = 0;

    TensorFlowNativeModel(String name, ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDMap, GraphDef trainedGraphDef, Map<String, TensorFlowUtil.TensorTuple> tensorMap, int batchSize, String outputName, FeatureConverter featureConverter, OutputConverter<T> outputConverter) {
        super(name, description, featureIDMap, outputIDMap, trainedGraphDef, batchSize, outputName, featureConverter, outputConverter);
        TensorFlowUtil.restoreMarshalledVariables(this.session, tensorMap);
    }

    public static TensorFlowNativeModel<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        TensorFlowNativeModelProto proto = (TensorFlowNativeModelProto)message.unpack(TensorFlowNativeModelProto.class);
        OutputConverter outputConverter = (OutputConverter)ProtoUtil.deserialize((Message)proto.getOutputConverter());
        FeatureConverter featureConverter = (FeatureConverter)ProtoUtil.deserialize((Message)proto.getFeatureConverter());
        ModelDataCarrier carrier = ModelDataCarrier.deserialize((ModelDataProto)proto.getMetadata());
        if (!carrier.outputDomain().getOutput(0).getClass().equals(outputConverter.getTypeWitness())) {
            throw new IllegalStateException("Invalid protobuf, output domain does not match converter, found " + carrier.outputDomain().getClass() + " and " + outputConverter.getTypeWitness());
        }
        GraphDef graphDef = GraphDef.parseFrom((ByteString)proto.getModelDef());
        HashMap<String, TensorFlowUtil.TensorTuple> tensorMap = new HashMap<String, TensorFlowUtil.TensorTuple>();
        for (Map.Entry<String, TensorTupleProto> e : proto.getTensorsMap().entrySet()) {
            tensorMap.put(e.getKey(), new TensorFlowUtil.TensorTuple(e.getValue()));
        }
        return new TensorFlowNativeModel(carrier.name(), carrier.provenance(), carrier.featureDomain(), carrier.outputDomain(), graphDef, tensorMap, proto.getBatchSize(), proto.getOutputName(), featureConverter, outputConverter);
    }

    protected TensorFlowNativeModel<T> copy(String newName, ModelProvenance newProvenance) {
        return new TensorFlowNativeModel<T>(newName, newProvenance, this.featureIDMap, this.outputIDInfo, this.modelGraph.toGraphDef(), TensorFlowUtil.extractMarshalledVariables(this.modelGraph, this.session), this.batchSize, this.outputName, this.featureConverter, this.outputConverter);
    }

    public TensorFlowCheckpointModel<T> convertToCheckpointModel(String checkpointDirectory, String checkpointName) {
        this.session.save(Paths.get(checkpointDirectory, checkpointName).toString());
        return new TensorFlowCheckpointModel(this.name, this.provenance, this.featureIDMap, this.outputIDInfo, this.modelGraph.toGraphDef(), checkpointDirectory, checkpointName, this.batchSize, this.outputName, this.featureConverter, this.outputConverter);
    }

    public ModelProto serialize() {
        ModelDataCarrier carrier = this.createDataCarrier();
        HashMap<String, TensorTupleProto> tensors = new HashMap<String, TensorTupleProto>();
        for (Map.Entry<String, TensorFlowUtil.TensorTuple> e : TensorFlowUtil.extractMarshalledVariables(this.modelGraph, this.session).entrySet()) {
            tensors.put(e.getKey(), e.getValue().serialize());
        }
        TensorFlowNativeModelProto.Builder modelBuilder = TensorFlowNativeModelProto.newBuilder();
        modelBuilder.setMetadata(carrier.serialize());
        modelBuilder.setModelDef(ByteString.copyFrom((byte[])this.modelGraph.toGraphDef().toByteArray()));
        modelBuilder.putAllTensors(tensors);
        modelBuilder.setOutputName(this.outputName);
        modelBuilder.setBatchSize(this.batchSize);
        modelBuilder.setOutputConverter((OutputConverterProto)this.outputConverter.serialize());
        modelBuilder.setFeatureConverter((FeatureConverterProto)this.featureConverter.serialize());
        ModelProto.Builder builder = ModelProto.newBuilder();
        builder.setSerializedData(Any.pack((Message)modelBuilder.build()));
        builder.setClassName(TensorFlowNativeModel.class.getName());
        builder.setVersion(0);
        return builder.build();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Can't serialize a closed model, the state has gone.");
        }
        out.defaultWriteObject();
        byte[] modelBytes = this.modelGraph.toGraphDef().toByteArray();
        out.writeObject(modelBytes);
        Map<String, TensorFlowUtil.TensorTuple> tensorMap = TensorFlowUtil.extractMarshalledVariables(this.modelGraph, this.session);
        out.writeObject(tensorMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] modelBytes = (byte[])in.readObject();
        Map tensorMap = (Map)in.readObject();
        this.modelGraph = new Graph();
        this.modelGraph.importGraphDef(GraphDef.parseFrom((byte[])modelBytes));
        this.session = new Session(this.modelGraph);
        TensorFlowUtil.restoreMarshalledVariables(this.session, tensorMap);
    }
}

