/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.interop.tensorflow;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Tensor;
import org.tensorflow.exceptions.TensorFlowException;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.Prediction;
import org.tribuo.impl.ModelDataCarrier;
import org.tribuo.interop.ExternalDatasetProvenance;
import org.tribuo.interop.ExternalModel;
import org.tribuo.interop.ExternalTrainerProvenance;
import org.tribuo.interop.tensorflow.FeatureConverter;
import org.tribuo.interop.tensorflow.OutputConverter;
import org.tribuo.interop.tensorflow.TensorMap;
import org.tribuo.interop.tensorflow.protos.FeatureConverterProto;
import org.tribuo.interop.tensorflow.protos.OutputConverterProto;
import org.tribuo.interop.tensorflow.protos.TensorFlowSavedModelExternalModelProto;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.SparseVector;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.ModelDataProto;
import org.tribuo.protos.core.ModelProto;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.provenance.TrainerProvenance;
import org.tribuo.util.Util;

public final class TensorFlowSavedModelExternalModel<T extends Output<T>>
extends ExternalModel<T, TensorMap, TensorMap>
implements Closeable {
    private static final long serialVersionUID = 200L;
    public static final int CURRENT_VERSION = 0;
    private final String modelDirectory;
    private transient SavedModelBundle bundle;
    private final FeatureConverter featureConverter;
    private final OutputConverter<T> outputConverter;
    private final String outputName;

    private TensorFlowSavedModelExternalModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, Map<String, Integer> featureMapping, String modelDirectory, String outputName, FeatureConverter featureConverter, OutputConverter<T> outputConverter) {
        super(name, provenance, featureIDMap, outputIDInfo, outputConverter.generatesProbabilities(), featureMapping);
        this.modelDirectory = modelDirectory;
        this.outputName = outputName;
        this.featureConverter = featureConverter;
        this.outputConverter = outputConverter;
        SavedModelBundle.Loader loader = SavedModelBundle.loader((String)modelDirectory);
        this.bundle = loader.load();
    }

    private TensorFlowSavedModelExternalModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, int[] featureForwardMapping, int[] featureBackwardMapping, String modelDirectory, String outputName, FeatureConverter featureConverter, OutputConverter<T> outputConverter) {
        super(name, provenance, featureIDMap, outputIDInfo, featureForwardMapping, featureBackwardMapping, outputConverter.generatesProbabilities());
        this.modelDirectory = modelDirectory;
        this.outputName = outputName;
        this.featureConverter = featureConverter;
        this.outputConverter = outputConverter;
        SavedModelBundle.Loader loader = SavedModelBundle.loader((String)modelDirectory);
        this.bundle = loader.load();
    }

    public static TensorFlowSavedModelExternalModel<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        int[] featureBackwardMapping;
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        TensorFlowSavedModelExternalModelProto proto = (TensorFlowSavedModelExternalModelProto)message.unpack(TensorFlowSavedModelExternalModelProto.class);
        OutputConverter outputConverter = (OutputConverter)ProtoUtil.deserialize((Message)proto.getOutputConverter());
        FeatureConverter featureConverter = (FeatureConverter)ProtoUtil.deserialize((Message)proto.getFeatureConverter());
        ModelDataCarrier carrier = ModelDataCarrier.deserialize((ModelDataProto)proto.getMetadata());
        if (!carrier.outputDomain().getOutput(0).getClass().equals(outputConverter.getTypeWitness())) {
            throw new IllegalStateException("Invalid protobuf, output domain does not match converter, found " + carrier.outputDomain().getClass() + " and " + outputConverter.getTypeWitness());
        }
        int[] featureForwardMapping = Util.toPrimitiveInt(proto.getForwardFeatureMappingList());
        if (!TensorFlowSavedModelExternalModel.validateFeatureMapping((int[])featureForwardMapping, (int[])(featureBackwardMapping = Util.toPrimitiveInt(proto.getBackwardFeatureMappingList())), (ImmutableFeatureMap)carrier.featureDomain())) {
            throw new IllegalStateException("Invalid protobuf, external<->Tribuo feature mapping does not form a bijection");
        }
        return new TensorFlowSavedModelExternalModel(carrier.name(), carrier.provenance(), carrier.featureDomain(), carrier.outputDomain(), featureForwardMapping, featureBackwardMapping, proto.getModelDirectory(), proto.getOutputName(), featureConverter, outputConverter);
    }

    protected TensorMap convertFeatures(SparseVector input) {
        return this.featureConverter.convert((SGDVector)input);
    }

    protected TensorMap convertFeaturesList(List<SparseVector> input) {
        return this.featureConverter.convert(input);
    }

    protected TensorMap externalPrediction(TensorMap input) {
        Map output = this.bundle.call(input.getMap());
        input.close();
        return new TensorMap(output);
    }

    protected Prediction<T> convertOutput(TensorMap output, int numValidFeatures, Example<T> example) {
        Optional<Tensor> tensor = output.getTensor(this.outputName);
        if (tensor.isPresent()) {
            Prediction<T> pred = this.outputConverter.convertToPrediction(tensor.get(), this.outputIDInfo, numValidFeatures, example);
            output.close();
            return pred;
        }
        output.close();
        throw new IllegalArgumentException("Failed to find '" + this.outputName + "' in model output. Found " + output);
    }

    protected List<Prediction<T>> convertOutput(TensorMap output, int[] numValidFeatures, List<Example<T>> examples) {
        Optional<Tensor> tensor = output.getTensor(this.outputName);
        if (tensor.isPresent()) {
            List<Prediction<T>> predictions = this.outputConverter.convertToBatchPrediction(tensor.get(), this.outputIDInfo, numValidFeatures, examples);
            output.close();
            return predictions;
        }
        output.close();
        throw new IllegalArgumentException("Failed to find '" + this.outputName + "' in model output. Found " + output);
    }

    public Map<String, List<Pair<String, Double>>> getTopFeatures(int n) {
        return Collections.emptyMap();
    }

    protected Model<T> copy(String newName, ModelProvenance newProvenance) {
        return new TensorFlowSavedModelExternalModel<T>(newName, newProvenance, this.featureIDMap, this.outputIDInfo, this.featureForwardMapping, this.featureBackwardMapping, this.modelDirectory, this.outputName, this.featureConverter, this.outputConverter);
    }

    @Override
    public void close() {
        if (this.bundle != null) {
            this.bundle.close();
        }
    }

    public ModelProto serialize() {
        ModelDataCarrier carrier = this.createDataCarrier();
        TensorFlowSavedModelExternalModelProto.Builder modelBuilder = TensorFlowSavedModelExternalModelProto.newBuilder();
        modelBuilder.setMetadata(carrier.serialize());
        modelBuilder.setOutputName(this.outputName);
        modelBuilder.setModelDirectory(this.modelDirectory);
        modelBuilder.addAllForwardFeatureMapping(Arrays.stream(this.featureForwardMapping).boxed().collect(Collectors.toList()));
        modelBuilder.addAllBackwardFeatureMapping(Arrays.stream(this.featureBackwardMapping).boxed().collect(Collectors.toList()));
        modelBuilder.setOutputConverter((OutputConverterProto)this.outputConverter.serialize());
        modelBuilder.setFeatureConverter((FeatureConverterProto)this.featureConverter.serialize());
        ModelProto.Builder builder = ModelProto.newBuilder();
        builder.setSerializedData(Any.pack((Message)modelBuilder.build()));
        builder.setClassName(TensorFlowSavedModelExternalModel.class.getName());
        builder.setVersion(0);
        return builder.build();
    }

    public static <T extends Output<T>> TensorFlowSavedModelExternalModel<T> createTensorflowModel(OutputFactory<T> factory, Map<String, Integer> featureMapping, Map<T, Integer> outputMapping, String outputName, FeatureConverter featureConverter, OutputConverter<T> outputConverter, String bundleDirectory) {
        try {
            Path path = Paths.get(bundleDirectory, new String[0]);
            URL provenanceLocation = path.toUri().toURL();
            ImmutableFeatureMap featureMap = ExternalModel.createFeatureMap(featureMapping.keySet());
            ImmutableOutputInfo outputInfo = ExternalModel.createOutputInfo(factory, outputMapping);
            OffsetDateTime now = OffsetDateTime.now();
            ExternalTrainerProvenance trainerProvenance = new ExternalTrainerProvenance(provenanceLocation);
            ExternalDatasetProvenance datasetProvenance = new ExternalDatasetProvenance("unknown-external-data", factory, false, featureMapping.size(), outputMapping.size());
            ModelProvenance provenance = new ModelProvenance(TensorFlowSavedModelExternalModel.class.getName(), now, (DatasetProvenance)datasetProvenance, (TrainerProvenance)trainerProvenance);
            return new TensorFlowSavedModelExternalModel<T>("tf-saved-model-bundle", provenance, featureMap, outputInfo, featureMapping, bundleDirectory, outputName, featureConverter, outputConverter);
        }
        catch (IOException | TensorFlowException e) {
            throw new IllegalArgumentException("Unable to load model from path " + bundleDirectory, e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SavedModelBundle.Loader loader = SavedModelBundle.loader((String)this.modelDirectory);
        this.bundle = loader.load();
    }
}

