/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.interop.tensorflow;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.tensorflow.Session;
import org.tensorflow.Tensor;

public final class TensorMap
implements AutoCloseable {
    private final Map<String, Tensor> map;
    private boolean isClosed;

    public TensorMap(String inputName, Tensor value) {
        this.map = Collections.singletonMap(inputName, value);
        this.isClosed = false;
    }

    public TensorMap(Map<String, Tensor> map) {
        this.map = Collections.unmodifiableMap(map);
        this.isClosed = false;
    }

    public Map<String, Tensor> getMap() {
        return this.map;
    }

    public Optional<Tensor> getTensor(String key) {
        return Optional.ofNullable(this.map.get(key));
    }

    public Session.Runner feedInto(Session.Runner runner) {
        if (this.isClosed) {
            throw new IllegalStateException("Can't feed closed Tensors into a Runner.");
        }
        for (Map.Entry<String, Tensor> e : this.map.entrySet()) {
            runner.feed(e.getKey(), e.getValue());
        }
        return runner;
    }

    @Override
    public void close() {
        this.isClosed = true;
        for (Tensor t : this.map.values()) {
            t.close();
        }
    }

    public String toString() {
        return "TensorMap(" + this.map.entrySet().stream().map(e -> (String)e.getKey() + ":Shape" + ((Tensor)e.getValue()).shape().toString()).collect(Collectors.joining(",")) + ")";
    }
}

