/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.infotheory;

public final class Gamma {
    private static final double two52 = 4.503599627370496E15;
    private static final double half = 0.5;
    private static final double one = 1.0;
    private static final double zero = 0.0;
    private static final double pi = Math.PI;
    private static final double a0 = 0.07721566490153287;
    private static final double a1 = 0.3224670334241136;
    private static final double a2 = 0.06735230105312927;
    private static final double a3 = 0.020580808432516733;
    private static final double a4 = 0.007385550860814029;
    private static final double a5 = 0.0028905138367341563;
    private static final double a6 = 0.0011927076318336207;
    private static final double a7 = 5.100697921535113E-4;
    private static final double a8 = 2.2086279071390839E-4;
    private static final double a9 = 1.0801156724758394E-4;
    private static final double a10 = 2.5214456545125733E-5;
    private static final double a11 = 4.4864094961891516E-5;
    private static final double tc = 1.4616321449683622;
    private static final double tf = -0.12148629053584961;
    private static final double tt = -3.638676997039505E-18;
    private static final double t0 = 0.48383612272381005;
    private static final double t1 = -0.1475877229945939;
    private static final double t2 = 0.06462494023913339;
    private static final double t3 = -0.032788541075985965;
    private static final double t4 = 0.01797067508118204;
    private static final double t5 = -0.010314224129834144;
    private static final double t6 = 0.006100538702462913;
    private static final double t7 = -0.0036845201678113826;
    private static final double t8 = 0.0022596478090061247;
    private static final double t9 = -0.0014034646998923284;
    private static final double t10 = 8.81081882437654E-4;
    private static final double t11 = -5.385953053567405E-4;
    private static final double t12 = 3.1563207090362595E-4;
    private static final double t13 = -3.1275416837512086E-4;
    private static final double t14 = 3.355291926355191E-4;
    private static final double u0 = -0.07721566490153287;
    private static final double u1 = 0.6328270640250934;
    private static final double u2 = 1.4549225013723477;
    private static final double u3 = 0.9777175279633727;
    private static final double u4 = 0.22896372806469245;
    private static final double u5 = 0.013381091853678766;
    private static final double v1 = 2.4559779371304113;
    private static final double v2 = 2.128489763798934;
    private static final double v3 = 0.7692851504566728;
    private static final double v4 = 0.10422264559336913;
    private static final double v5 = 0.003217092422824239;
    private static final double s0 = -0.07721566490153287;
    private static final double s1 = 0.21498241596060885;
    private static final double s2 = 0.325778796408931;
    private static final double s3 = 0.14635047265246445;
    private static final double s4 = 0.02664227030336386;
    private static final double s5 = 0.0018402845140733772;
    private static final double s6 = 3.194753265841009E-5;
    private static final double r1 = 1.3920053346762105;
    private static final double r2 = 0.7219355475671381;
    private static final double r3 = 0.17193386563280308;
    private static final double r4 = 0.01864591917156529;
    private static final double r5 = 7.779424963818936E-4;
    private static final double r6 = 7.326684307446256E-6;
    private static final double w0 = 0.4189385332046727;
    private static final double w1 = 0.08333333333333297;
    private static final double w2 = -0.0027777777772877554;
    private static final double w3 = 7.936505586430196E-4;
    private static final double w4 = -5.9518755745034E-4;
    private static final double w5 = 8.363399189962821E-4;
    private static final double w6 = -0.0016309293409657527;

    private Gamma() {
    }

    private static int __LO(double x) {
        return (int)Double.doubleToRawLongBits(x);
    }

    private static int __HI(double x) {
        return (int)(Double.doubleToRawLongBits(x) >> 32);
    }

    private static double sin_pi(double x) {
        int n;
        int ix = Integer.MAX_VALUE & Gamma.__HI(x);
        if (ix < 1070596096) {
            return Math.sin(Math.PI * x);
        }
        double y = -x;
        double z = Math.floor(y);
        if (z != y) {
            y *= 0.5;
            y = 2.0 * (y - Math.floor(y));
            n = (int)(y * 4.0);
        } else if (ix >= 0x43400000) {
            y = 0.0;
            n = 0;
        } else {
            if (ix < 0x43300000) {
                z = y + 4.503599627370496E15;
            }
            n = Gamma.__LO(z) & 1;
            y = n;
            n <<= 2;
        }
        switch (n) {
            case 0: {
                y = Math.sin(Math.PI * y);
                break;
            }
            case 1: 
            case 2: {
                y = Math.cos(Math.PI * (0.5 - y));
                break;
            }
            case 3: 
            case 4: {
                y = Math.sin(Math.PI * (1.0 - y));
                break;
            }
            case 5: 
            case 6: {
                y = -Math.cos(Math.PI * (y - 1.5));
                break;
            }
            default: {
                y = Math.sin(Math.PI * (y - 2.0));
            }
        }
        return -y;
    }

    public static double logGamma(double x) {
        double r;
        double t;
        if (x <= 0.0 && Math.floor(x) == x) {
            return Double.NaN;
        }
        int hx = Gamma.__HI(x);
        int lx = Gamma.__LO(x);
        double nadj = 0.0;
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x7FF00000) {
            return x * x;
        }
        if ((ix | lx) == 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (ix < 999292928) {
            if (hx < 0) {
                return -Math.log(-x);
            }
            return -Math.log(x);
        }
        if (hx < 0) {
            if (ix >= 0x43300000) {
                return Double.POSITIVE_INFINITY;
            }
            t = Gamma.sin_pi(x);
            if (t == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            nadj = Math.log(Math.PI / Math.abs(t * x));
            x = -x;
        }
        if ((ix - 0x3FF00000 | lx) == 0 || (ix - 0x40000000 | lx) == 0) {
            r = 0.0;
        } else if (ix < 0x40000000) {
            int i;
            double y;
            if (ix <= 1072483532) {
                r = -Math.log(x);
                if (ix >= 1072130372) {
                    y = 1.0 - x;
                    i = 0;
                } else if (ix >= 1070442081) {
                    y = x - 0.46163214496836225;
                    i = 1;
                } else {
                    y = x;
                    i = 2;
                }
            } else {
                r = 0.0;
                if (ix >= 1073460419) {
                    y = 2.0 - x;
                    i = 0;
                } else if (ix >= 1072936132) {
                    y = x - 1.4616321449683622;
                    i = 1;
                } else {
                    y = x - 1.0;
                    i = 2;
                }
            }
            switch (i) {
                case 0: {
                    double z = y * y;
                    double p1 = 0.07721566490153287 + z * (0.06735230105312927 + z * (0.007385550860814029 + z * (0.0011927076318336207 + z * (2.2086279071390839E-4 + z * 2.5214456545125733E-5))));
                    double p2 = z * (0.3224670334241136 + z * (0.020580808432516733 + z * (0.0028905138367341563 + z * (5.100697921535113E-4 + z * (1.0801156724758394E-4 + z * 4.4864094961891516E-5)))));
                    double p = y * p1 + p2;
                    r += p - 0.5 * y;
                    break;
                }
                case 1: {
                    double z = y * y;
                    double w = z * y;
                    double p1 = 0.48383612272381005 + w * (-0.032788541075985965 + w * (0.006100538702462913 + w * (-0.0014034646998923284 + w * 3.1563207090362595E-4)));
                    double p2 = -0.1475877229945939 + w * (0.01797067508118204 + w * (-0.0036845201678113826 + w * (8.81081882437654E-4 + w * -3.1275416837512086E-4)));
                    double p3 = 0.06462494023913339 + w * (-0.010314224129834144 + w * (0.0022596478090061247 + w * (-5.385953053567405E-4 + w * 3.355291926355191E-4)));
                    double p = z * p1 - (-3.638676997039505E-18 - w * (p2 + y * p3));
                    r += -0.12148629053584961 + p;
                    break;
                }
                case 2: {
                    double p1 = y * (-0.07721566490153287 + y * (0.6328270640250934 + y * (1.4549225013723477 + y * (0.9777175279633727 + y * (0.22896372806469245 + y * 0.013381091853678766)))));
                    double p2 = 1.0 + y * (2.4559779371304113 + y * (2.128489763798934 + y * (0.7692851504566728 + y * (0.10422264559336913 + y * 0.003217092422824239))));
                    r += -0.5 * y + p1 / p2;
                }
            }
        } else if (ix < 0x40200000) {
            int i = (int)x;
            t = 0.0;
            double y = x - (double)i;
            double p = y * (-0.07721566490153287 + y * (0.21498241596060885 + y * (0.325778796408931 + y * (0.14635047265246445 + y * (0.02664227030336386 + y * (0.0018402845140733772 + y * 3.194753265841009E-5))))));
            double q = 1.0 + y * (1.3920053346762105 + y * (0.7219355475671381 + y * (0.17193386563280308 + y * (0.01864591917156529 + y * (7.779424963818936E-4 + y * 7.326684307446256E-6)))));
            r = 0.5 * y + p / q;
            double z = 1.0;
            switch (i) {
                case 7: {
                    z *= y + 6.0;
                }
                case 6: {
                    z *= y + 5.0;
                }
                case 5: {
                    z *= y + 4.0;
                }
                case 4: {
                    z *= y + 3.0;
                }
                case 3: {
                    r += Math.log(z *= y + 2.0);
                }
            }
        } else if (ix < 1133510656) {
            t = Math.log(x);
            double z = 1.0 / x;
            double y = z * z;
            double w = 0.4189385332046727 + z * (0.08333333333333297 + y * (-0.0027777777772877554 + y * (7.936505586430196E-4 + y * (-5.9518755745034E-4 + y * (8.363399189962821E-4 + y * -0.0016309293409657527)))));
            r = (x - 0.5) * (t - 1.0) + w;
        } else {
            r = x * (Math.log(x) - 1.0);
        }
        if (hx < 0) {
            r = nadj - r;
        }
        return r;
    }

    private static int getSign(double x) {
        if (x < 0.0 && (int)x % 2 == 0) {
            return -1;
        }
        return 1;
    }

    public static double gamma(double x) {
        double r = Gamma.logGamma(x);
        int sign = Gamma.getSign(x);
        return (double)sign * Math.exp(r);
    }

    public static double regularizedGammaP(int a, double x, double epsilon, int maxIterations) {
        int i;
        double ithElement;
        if (Double.isNaN(x) || a <= 0 || x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        double accumulator = ithElement = 1.0 / (double)a;
        for (i = 1; i < maxIterations && Math.abs(ithElement / accumulator) > epsilon; ++i) {
            if (!Double.isInfinite(accumulator += (ithElement *= x / (double)(a + i)))) continue;
            return 1.0;
        }
        if (i >= maxIterations) {
            throw new IllegalStateException("Exceeded maximum number of iterations " + maxIterations);
        }
        return Math.exp(-x + (double)a * Math.log(x) - Gamma.logGamma(a)) * accumulator;
    }
}

