/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.onnx;

import ai.onnx.proto.OnnxMl;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.tribuo.util.onnx.ONNXAttribute;
import org.tribuo.util.onnx.ONNXContext;

public interface ONNXOperator {
    public String getOpName();

    public int getNumInputs();

    public int getNumOptionalInputs();

    public int getNumOutputs();

    public Map<String, ONNXAttribute> getAttributes();

    public Set<String> getMandatoryAttributeNames();

    public int getOpVersion();

    public String getOpDomain();

    default public OnnxMl.OperatorSetIdProto opsetProto() {
        return OnnxMl.OperatorSetIdProto.newBuilder().setDomain(this.getOpDomain()).setVersion(this.getOpVersion()).build();
    }

    default public OnnxMl.NodeProto build(ONNXContext context, String input, String output) {
        return this.build(context, new String[]{input}, new String[]{output}, Collections.emptyMap());
    }

    default public OnnxMl.NodeProto build(ONNXContext context, String input, String output, Map<String, Object> attributeValues) {
        return this.build(context, new String[]{input}, new String[]{output}, attributeValues);
    }

    default public OnnxMl.NodeProto build(ONNXContext context, String[] inputs, String output) {
        return this.build(context, inputs, new String[]{output}, Collections.emptyMap());
    }

    default public OnnxMl.NodeProto build(ONNXContext context, String[] inputs, String output, Map<String, Object> attributeValues) {
        return this.build(context, inputs, new String[]{output}, attributeValues);
    }

    default public OnnxMl.NodeProto build(ONNXContext context, String input, String[] outputs) {
        return this.build(context, new String[]{input}, outputs, Collections.emptyMap());
    }

    default public OnnxMl.NodeProto build(ONNXContext context, String input, String[] outputs, Map<String, Object> attributeValues) {
        return this.build(context, new String[]{input}, outputs, attributeValues);
    }

    default public OnnxMl.NodeProto build(ONNXContext context, String[] inputs, String[] outputs) {
        return this.build(context, inputs, outputs, Collections.emptyMap());
    }

    default public OnnxMl.NodeProto build(ONNXContext context, String[] inputs, String[] outputs, Map<String, Object> attributeValues) {
        int numInputs = this.getNumInputs();
        int numOptionalInputs = this.getNumOptionalInputs();
        int numOutputs = this.getNumOutputs();
        String opName = this.getOpName();
        String domain = this.getOpDomain();
        Map<String, ONNXAttribute> attributes = this.getAttributes();
        Set<String> mandatoryAttributeNames = this.getMandatoryAttributeNames();
        String opStatus = String.format("Building op %s:%s(%d(+%d)) -> %d", domain, opName, numInputs, numOptionalInputs, numOutputs);
        if (numInputs != -1 && (inputs.length < numInputs || inputs.length > numInputs + numOptionalInputs)) {
            throw new IllegalArgumentException(opStatus + ". Expected " + numInputs + " inputs, with " + numOptionalInputs + " optional inputs, but received " + inputs.length);
        }
        if (numInputs == -1 && inputs.length == 0) {
            throw new IllegalArgumentException(opStatus + ". Expected at least one input for variadic input, received zero");
        }
        if (outputs.length != numOutputs) {
            throw new IllegalArgumentException(opStatus + ". Expected " + numOutputs + " outputs, but received " + outputs.length);
        }
        if (!attributes.keySet().containsAll(attributeValues.keySet())) {
            throw new IllegalArgumentException(opStatus + ". Unexpected attribute found, received " + attributeValues.keySet() + ", expected values from " + attributes.keySet());
        }
        if (!attributeValues.keySet().containsAll(mandatoryAttributeNames)) {
            throw new IllegalArgumentException(opStatus + ". Expected to find all mandatory attributes, received " + attributeValues.keySet() + ", expected " + mandatoryAttributeNames);
        }
        Logger.getLogger("org.tribuo.util.onnx.ONNXOperator").fine(opStatus);
        OnnxMl.NodeProto.Builder nodeBuilder = OnnxMl.NodeProto.newBuilder();
        for (String i : inputs) {
            nodeBuilder.addInput(i);
        }
        for (String o : outputs) {
            nodeBuilder.addOutput(o);
        }
        nodeBuilder.setName(context.generateUniqueName(opName));
        nodeBuilder.setOpType(opName);
        if (domain != null) {
            nodeBuilder.setDomain(domain);
        }
        for (Map.Entry entry : attributeValues.entrySet()) {
            ONNXAttribute attr = attributes.get(entry.getKey());
            nodeBuilder.addAttribute(attr.build(entry.getValue()));
        }
        return nodeBuilder.build();
    }
}

