/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.onnx;

import ai.onnx.proto.OnnxMl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tribuo.util.onnx.ONNXAttribute;
import org.tribuo.util.onnx.ONNXOperator;

public enum ONNXOperators implements ONNXOperator
{
    IDENTITY("Identity", 1, 1),
    CONCAT("Concat", -1, 1, Collections.singletonList(new ONNXAttribute("axis", OnnxMl.AttributeProto.AttributeType.INT, true))),
    CONSTANT_OF_SHAPE("ConstantOfShape", 1, 1, Collections.singletonList(new ONNXAttribute("value", OnnxMl.AttributeProto.AttributeType.TENSOR, false))),
    SIGMOID("Sigmoid", 1, 1),
    SOFTMAX("Softmax", 1, 1, Collections.singletonList(new ONNXAttribute("axis", OnnxMl.AttributeProto.AttributeType.INT, false))),
    CAST("Cast", 1, 1, Collections.singletonList(new ONNXAttribute("to", OnnxMl.AttributeProto.AttributeType.INT, true))),
    NEG("Neg", 1, 1),
    ADD("Add", 2, 1),
    SUB("Sub", 2, 1),
    MUL("Mul", 2, 1),
    DIV("Div", 2, 1),
    POW("Pow", 2, 1),
    SUM("Sum", -1, 1),
    GATHER("Gather", 2, 1, Collections.singletonList(new ONNXAttribute("axis", OnnxMl.AttributeProto.AttributeType.INT, true))),
    HARDMAX("Hardmax", 1, 1, Collections.singletonList(new ONNXAttribute("axis", OnnxMl.AttributeProto.AttributeType.INT, false))),
    REDUCE_MEAN("ReduceMean", 1, 1, Arrays.asList(new ONNXAttribute("axes", OnnxMl.AttributeProto.AttributeType.INTS, false), new ONNXAttribute("keepdims", OnnxMl.AttributeProto.AttributeType.INT, false))),
    REDUCE_MIN("ReduceMin", 1, 1, Arrays.asList(new ONNXAttribute("axes", OnnxMl.AttributeProto.AttributeType.INTS, false), new ONNXAttribute("keepdims", OnnxMl.AttributeProto.AttributeType.INT, false))),
    REDUCE_SUM("ReduceSum", 1, 1, 1, Arrays.asList(new ONNXAttribute("keepdims", OnnxMl.AttributeProto.AttributeType.INT, false), new ONNXAttribute("noop_with_empty_axes", OnnxMl.AttributeProto.AttributeType.INT, false))),
    UNSQUEEZE("Unsqueeze", 2, 1),
    GEMM("Gemm", 2, 1, 1, Arrays.asList(new ONNXAttribute("alpha", OnnxMl.AttributeProto.AttributeType.FLOAT, false), new ONNXAttribute("beta", OnnxMl.AttributeProto.AttributeType.FLOAT, false), new ONNXAttribute("transA", OnnxMl.AttributeProto.AttributeType.INT, false), new ONNXAttribute("transB", OnnxMl.AttributeProto.AttributeType.INT, false))),
    GREATER("Greater", 2, 1),
    GREATER_OR_EQUAL("GreaterOrEqual", 2, 1),
    LESS("Less", 2, 1),
    LESS_OR_EQUAL("LessOrEqual", 2, 1),
    WHERE("Where", 3, 1),
    ARRAY_FEATURE_EXTRACTOR("ArrayFeatureExtractor", 2, 1, "ai.onnx.ml"),
    SVM_CLASSIFIER("SVMClassifier", 1, 2, "ai.onnx.ml", Arrays.asList(new ONNXAttribute("classlabels_ints", OnnxMl.AttributeProto.AttributeType.INTS, false), new ONNXAttribute("classlabels_strings", OnnxMl.AttributeProto.AttributeType.STRINGS, false), new ONNXAttribute("coefficients", OnnxMl.AttributeProto.AttributeType.FLOATS, true), new ONNXAttribute("kernel_params", OnnxMl.AttributeProto.AttributeType.FLOATS, true), new ONNXAttribute("kernel_type", OnnxMl.AttributeProto.AttributeType.STRING, false), new ONNXAttribute("post_transform", OnnxMl.AttributeProto.AttributeType.STRING, false), new ONNXAttribute("prob_a", OnnxMl.AttributeProto.AttributeType.FLOATS, false), new ONNXAttribute("prob_b", OnnxMl.AttributeProto.AttributeType.FLOATS, false), new ONNXAttribute("rho", OnnxMl.AttributeProto.AttributeType.FLOATS, true), new ONNXAttribute("support_vectors", OnnxMl.AttributeProto.AttributeType.FLOATS, true), new ONNXAttribute("vectors_per_class", OnnxMl.AttributeProto.AttributeType.INTS, true))),
    SVM_REGRESSOR("SVMRegressor", 1, 1, "ai.onnx.ml", Arrays.asList(new ONNXAttribute("coefficients", OnnxMl.AttributeProto.AttributeType.FLOATS, true), new ONNXAttribute("kernel_params", OnnxMl.AttributeProto.AttributeType.FLOATS, true), new ONNXAttribute("kernel_type", OnnxMl.AttributeProto.AttributeType.STRING, false), new ONNXAttribute("n_supports", OnnxMl.AttributeProto.AttributeType.INT, true), new ONNXAttribute("one_class", OnnxMl.AttributeProto.AttributeType.INT, false), new ONNXAttribute("post_transform", OnnxMl.AttributeProto.AttributeType.STRING, false), new ONNXAttribute("rho", OnnxMl.AttributeProto.AttributeType.FLOATS, true), new ONNXAttribute("support_vectors", OnnxMl.AttributeProto.AttributeType.FLOATS, true)));

    public final String opName;
    public final int numInputs;
    public final int numOptionalInputs;
    public final int numOutputs;
    public final Map<String, ONNXAttribute> attributes;
    public final Set<String> mandatoryAttributeNames;
    public final String domain;
    private static final int OPSET_VERSION = 13;

    private ONNXOperators(String value, int numInputs, int numOutputs) {
        this(value, numInputs, 0, numOutputs);
    }

    private ONNXOperators(String value, int numInputs, int numOptionalInputs, int numOutputs) {
        this(value, numInputs, numOptionalInputs, numOutputs, (String)null);
    }

    private ONNXOperators(String value, int numInputs, int numOutputs, String domain) {
        this(value, numInputs, 0, numOutputs, domain);
    }

    private ONNXOperators(String value, int numInputs, int numOptionalInputs, int numOutputs, String domain) {
        this.opName = value;
        this.numInputs = numInputs;
        this.numOptionalInputs = numOptionalInputs;
        this.numOutputs = numOutputs;
        this.attributes = Collections.emptyMap();
        this.mandatoryAttributeNames = Collections.emptySet();
        this.domain = domain;
    }

    private ONNXOperators(String value, int numInputs, int numOutputs, List<ONNXAttribute> attributes) {
        this(value, numInputs, 0, numOutputs, attributes);
    }

    private ONNXOperators(String value, int numInputs, int numOutputs, String domain, List<ONNXAttribute> attributes) {
        this(value, numInputs, 0, numOutputs, domain, attributes);
    }

    private ONNXOperators(String value, int numInputs, int numOptionalInputs, int numOutputs, List<ONNXAttribute> attributes) {
        this(value, numInputs, numOptionalInputs, numOutputs, null, attributes);
    }

    private ONNXOperators(String value, int numInputs, int numOptionalInputs, int numOutputs, String domain, List<ONNXAttribute> attributes) {
        this.opName = value;
        this.numInputs = numInputs;
        this.numOptionalInputs = numOptionalInputs;
        this.numOutputs = numOutputs;
        HashMap<String, ONNXAttribute> attributeMap = new HashMap<String, ONNXAttribute>();
        HashSet<String> attributeSet = new HashSet<String>();
        for (ONNXAttribute a : attributes) {
            attributeMap.put(a.getName(), a);
            if (!a.isMandatory()) continue;
            attributeSet.add(a.getName());
        }
        if (attributes.size() != attributeMap.size()) {
            throw new IllegalArgumentException("Duplicate attribute in enum declaration - " + attributes);
        }
        this.attributes = Collections.unmodifiableMap(attributeMap);
        this.mandatoryAttributeNames = attributeSet.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(attributeSet);
        this.domain = domain;
    }

    @Override
    public String getOpName() {
        return this.opName;
    }

    @Override
    public int getNumInputs() {
        return this.numInputs;
    }

    @Override
    public int getNumOptionalInputs() {
        return this.numOptionalInputs;
    }

    @Override
    public int getNumOutputs() {
        return this.numOutputs;
    }

    @Override
    public Map<String, ONNXAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<String> getMandatoryAttributeNames() {
        return this.mandatoryAttributeNames;
    }

    @Override
    public int getOpVersion() {
        return ONNXOperators.getOpsetVersion();
    }

    @Override
    public String getOpDomain() {
        return this.domain;
    }

    public static int getOpsetVersion() {
        return 13;
    }

    public static OnnxMl.OperatorSetIdProto getOpsetProto() {
        return OnnxMl.OperatorSetIdProto.newBuilder().setVersion(ONNXOperators.getOpsetVersion()).build();
    }
}

