/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.minify;

import com.googlecode.htmlcompressor.compressor.Compressor;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.config.Configuration;
import org.trimou.exception.MustacheException;
import org.trimou.minify.AbstractMinifier;
import org.trimou.util.IOUtils;

public abstract class CompressorMinifier<T extends Compressor>
extends AbstractMinifier {
    private static final Logger logger = LoggerFactory.getLogger(CompressorMinifier.class);
    T compressor;

    public CompressorMinifier(T compressor) {
        this.compressor = compressor;
    }

    public void init(Configuration configuration) {
        this.initCompressor(this.compressor, configuration);
    }

    @Override
    public Reader minify(String mustacheName, Reader mustacheContents) {
        if (!this.match(mustacheName)) {
            return mustacheContents;
        }
        try {
            String source = IOUtils.toString((Reader)mustacheContents);
            String compressed = this.compressor.compress(source);
            logger.debug("Compression finished [saving: {} bytes]", (Object)(source.length() - compressed.length()));
            return new StringReader(compressed);
        }
        catch (Exception e) {
            throw new MustacheException("Unable to compress the template contents", (Throwable)e);
        }
    }

    @Override
    public String minify(String text) {
        String compressed = this.compressor.compress(text);
        logger.debug("Compression finished [saving: {} bytes]", (Object)(text.length() - compressed.length()));
        return compressed;
    }

    protected boolean match(String mustacheName) {
        return true;
    }

    protected void initCompressor(T compressor, Configuration configuration) {
    }
}

