/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.minify;

import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.lambda.Lambda;
import org.trimou.minify.Minifier;
import org.trimou.util.Checker;

public class MinifyLambda
implements Lambda,
MustacheEngineBuilder.EngineBuiltCallback {
    private final Lambda.InputType inputType;
    private final boolean isReturnValueInterpolated;
    private final Minifier minifier;

    public MinifyLambda(Minifier minifier) {
        this.minifier = minifier;
        this.inputType = Lambda.InputType.PROCESSED;
        this.isReturnValueInterpolated = false;
    }

    public MinifyLambda(Lambda.InputType inputType, boolean isReturnValueInterpolated, Minifier minifier) {
        Checker.checkArgumentNotNull((Object)inputType);
        this.inputType = inputType;
        this.isReturnValueInterpolated = isReturnValueInterpolated;
        this.minifier = minifier;
    }

    public String invoke(String text) {
        return this.minifier.minify(text);
    }

    public Lambda.InputType getInputType() {
        return this.inputType;
    }

    public boolean isReturnValueInterpolated() {
        return this.isReturnValueInterpolated;
    }

    public void engineBuilt(MustacheEngine engine) {
        this.minifier.init(engine.getConfiguration());
    }
}

