/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.prettytime;

import java.util.Date;
import java.util.Locale;
import org.ocpsoft.prettytime.PrettyTime;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.convert.Converter;
import org.trimou.engine.convert.ObjectToDateConverter;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.Options;
import org.trimou.handlebars.i18n.LocaleAwareValueHelper;
import org.trimou.prettytime.DefaultPrettyTimeFactory;
import org.trimou.prettytime.PrettyTimeFactory;
import org.trimou.util.Checker;

public class PrettyTimeHelper
extends LocaleAwareValueHelper {
    public static final String COMPUTING_CACHE_CONSUMER_ID = PrettyTimeHelper.class.getName();
    private final PrettyTimeFactory factory;
    private final Converter<Object, Date> converter;
    private ComputingCache<Locale, PrettyTime> prettyTimeCache;

    public PrettyTimeHelper() {
        this(new DefaultPrettyTimeFactory());
    }

    public PrettyTimeHelper(PrettyTimeFactory prettyTimeFactory) {
        this(prettyTimeFactory, (Converter<Object, Date>)new ObjectToDateConverter());
    }

    private PrettyTimeHelper(PrettyTimeFactory factory, Converter<Object, Date> converter) {
        Checker.checkArgumentsNotNull((Object[])new Object[]{factory, converter});
        this.factory = factory;
        this.converter = converter;
    }

    public void init(Configuration configuration) {
        super.init(configuration);
        this.prettyTimeCache = configuration.getComputingCacheFactory().create(COMPUTING_CACHE_CONSUMER_ID, (ComputingCache.Function)new ComputingCache.Function<Locale, PrettyTime>(){

            public PrettyTime compute(Locale key) {
                return PrettyTimeHelper.this.factory.createPrettyTime(key);
            }
        }, null, Long.valueOf(10L), null);
    }

    public void execute(Options options) {
        Object param = options.getParameters().get(0);
        if (param == null) {
            throw new MustacheException((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "PrettyTimeHelper - no instance to format [template: %s, line: %s, param: %s]", new Object[]{options.getTagInfo().getTemplateName(), options.getTagInfo().getLine()});
        }
        Date value = (Date)this.converter.convert(param);
        if (value == null) {
            throw new MustacheException((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "Unable to get java.util.Date instance for PrettyTime [template: %s, line: %s, param: %s]", new Object[]{options.getTagInfo().getTemplateName(), options.getTagInfo().getLine(), param});
        }
        this.append(options, ((PrettyTime)this.prettyTimeCache.get((Object)this.getLocale(options))).format(value));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PrettyTimeFactory factory;
        private Converter<Object, Date> converter;

        public Builder setFactory(PrettyTimeFactory factory) {
            this.factory = factory;
            return this;
        }

        public Builder setConverter(Converter<Object, Date> converter) {
            this.converter = converter;
            return this;
        }

        public PrettyTimeHelper build() {
            if (this.factory == null) {
                this.factory = new DefaultPrettyTimeFactory();
            }
            if (this.converter == null) {
                this.converter = new ObjectToDateConverter();
            }
            return new PrettyTimeHelper(this.factory, this.converter);
        }
    }
}

