/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.prettytime.resolver;

import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.ocpsoft.prettytime.PrettyTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.convert.Converter;
import org.trimou.engine.convert.ObjectToDateConverter;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.ArrayIndexResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.TransformResolver;
import org.trimou.engine.validation.Validateable;
import org.trimou.prettytime.DefaultPrettyTimeFactory;
import org.trimou.prettytime.PrettyTimeFactory;
import org.trimou.util.Checker;

public class PrettyTimeResolver
extends TransformResolver
implements Validateable {
    public static final int PRETTY_TIME_RESOLVER_PRIORITY = Priorities.rightAfter((int)ArrayIndexResolver.ARRAY_RESOLVER_PRIORITY);
    public static final String COMPUTING_CACHE_CONSUMER_ID = PrettyTimeResolver.class.getName();
    public static final ConfigurationKey MATCH_NAME_KEY = new SimpleConfigurationKey(PrettyTimeResolver.class.getName() + ".matchName", (Object)"prettyTime");
    public static final ConfigurationKey ENABLED_KEY = new SimpleConfigurationKey(PrettyTimeResolver.class.getName() + ".enabled", (Object)true);
    private static final Logger logger = LoggerFactory.getLogger(PrettyTimeResolver.class);
    private final PrettyTimeFactory factory;
    private final Converter<Object, Date> converter;
    private ComputingCache<Locale, PrettyTime> prettyTimeCache;

    public PrettyTimeResolver() {
        this(PRETTY_TIME_RESOLVER_PRIORITY, new DefaultPrettyTimeFactory());
    }

    public PrettyTimeResolver(int priority, PrettyTimeFactory prettyTimeFactory) {
        this(priority, prettyTimeFactory, (Converter<Object, Date>)new ObjectToDateConverter());
    }

    public PrettyTimeResolver(int priority, PrettyTimeFactory factory, Converter<Object, Date> converter) {
        super(priority, new String[0]);
        Checker.checkArgumentsNotNull((Object[])new Object[]{factory, converter});
        this.factory = factory;
        this.converter = converter;
    }

    public Object transform(Object contextObject, String name, ResolutionContext context) {
        Date value = (Date)this.converter.convert(contextObject);
        if (value == null) {
            return null;
        }
        return ((PrettyTime)this.prettyTimeCache.get((Object)this.getCurrentLocale())).format(value);
    }

    public Set<ConfigurationKey> getConfigurationKeys() {
        return ImmutableSet.of((Object)MATCH_NAME_KEY, (Object)ENABLED_KEY);
    }

    public void init(Configuration configuration) {
        if (!configuration.getBooleanPropertyValue(ENABLED_KEY).booleanValue()) {
            return;
        }
        super.init(configuration);
        this.setMatchingNames(new String[]{configuration.getStringPropertyValue(MATCH_NAME_KEY)});
        this.prettyTimeCache = configuration.getComputingCacheFactory().create(COMPUTING_CACHE_CONSUMER_ID, (ComputingCache.Function)new ComputingCache.Function<Locale, PrettyTime>(){

            public PrettyTime compute(Locale key) {
                return PrettyTimeResolver.this.factory.createPrettyTime(key);
            }
        }, null, Long.valueOf(10L), null);
        logger.info("Initialized [matchingName: {}]", (Object)this.matchingName(0));
    }

    public boolean isValid() {
        return this.prettyTimeCache != null;
    }
}

