/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.AbstractCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;

public abstract class AbstractDockableCStation<S extends CommonDockStation<?, ?>>
extends AbstractCDockable
implements CStation<S> {
    private CLocation location;
    private String id;
    private S station;

    public AbstractDockableCStation(S station, String id, CLocation location, CommonDockable dockable) {
        this.init(station, id, location, dockable);
    }

    protected AbstractDockableCStation() {
    }

    protected void init(S station, String id, CLocation location, CommonDockable dockable) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        super.init(dockable);
        this.station = station;
        this.id = id;
        this.location = location;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getUniqueId() + "]";
    }

    @Override
    protected CommonDockable createCommonDockable() {
        throw new IllegalStateException("common-dockable should have been set by the constructor");
    }

    @Override
    public CLocation getStationLocation() {
        return this.location;
    }

    @Override
    public CLocation getDropLocation() {
        CControlAccess control = this.getControlAccess();
        if (control == null) {
            return null;
        }
        return control.getLocationManager().getDropLocation(this);
    }

    @Override
    public String getUniqueId() {
        return this.id;
    }

    @Override
    public S getStation() {
        return this.station;
    }

    @Override
    public CStation<?> asStation() {
        return this;
    }

    @Override
    public void setControlAccess(CControlAccess access) {
        CControlAccess control = this.getControlAccess();
        super.setControlAccess(access);
        if (control != access) {
            if (control != null) {
                this.uninstall(control);
            }
            if ((control = access) != null) {
                this.install(control);
            }
        }
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    @Override
    public CDockable asDockable() {
        return null;
    }

    protected abstract void install(CControlAccess var1);

    protected abstract void uninstall(CControlAccess var1);
}

