/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.perspective.CContentPerspective;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CExternalizePerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.MultipleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.ShrinkablePerspectiveStation;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModeManagerPerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class CPerspective {
    private Map<String, CStationPerspective> stations = new HashMap<String, CStationPerspective>();
    private Map<String, CDockablePerspective> dockables = new HashMap<String, CDockablePerspective>();
    private LocationModeManagerPerspective locationModeManager;
    private CControlAccess control;

    public CPerspective(CControlAccess control) {
        this.control = control;
        this.initLocations();
    }

    private void initLocations() {
        this.locationModeManager = new LocationModeManagerPerspective(this, this.control);
        CLocationModeManager manager = this.control.getLocationManager();
        for (CLocationMode mode : manager.modes()) {
            LocationModePerspective perspective = mode.createPerspective();
            if (perspective != null) {
                this.locationModeManager.addMode(perspective);
                continue;
            }
            System.err.println("warning: mode " + mode.getClass() + " does not provide perspective");
        }
    }

    public LocationModeManagerPerspective getLocationManager() {
        return this.locationModeManager;
    }

    public void storeLocations() {
        Iterator<PerspectiveElement> elements = this.elements();
        while (elements.hasNext()) {
            CDockablePerspective cdockable;
            PerspectiveElement dockable = elements.next();
            if (!(dockable instanceof CommonElementPerspective) || (cdockable = ((CommonElementPerspective)dockable).getElement().asDockable()) == null) continue;
            this.storeLocation(cdockable);
        }
    }

    public Location storeLocation(CDockablePerspective dockable) {
        Location location = this.getLocationManager().getLocation(dockable);
        if (location != null) {
            dockable.getLocationHistory().add(this.getLocationManager().getMode(location.getMode()), location);
            String id = this.getId(dockable);
            if (id != null) {
                this.dockables.put(id, dockable);
            }
        }
        return location;
    }

    private String getId(CDockablePerspective dockable) {
        String id = null;
        if (dockable instanceof SingleCDockablePerspective) {
            id = ((SingleCDockablePerspective)dockable).getUniqueId();
            if (id != null) {
                id = this.control.getRegister().toSingleId(id);
            }
        } else if (dockable instanceof MultipleCDockablePerspective && (id = ((MultipleCDockablePerspective)dockable).getUniqueId()) != null) {
            id = this.control.getRegister().toMultiId(id);
        }
        return id;
    }

    public void addStation(CStationPerspective station) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.stations.put(station.getUniqueId(), station);
        station.setPerspective(this);
    }

    public CStationPerspective getStation(String id) {
        return this.stations.get(id);
    }

    public CDockablePerspective getDockable(String id) {
        return this.dockables.get(id);
    }

    public String[] getDockableKeys() {
        return this.dockables.keySet().toArray(new String[this.dockables.size()]);
    }

    public CDockablePerspective removeDockable(String key) {
        return this.dockables.remove(key);
    }

    public void putDockable(CDockablePerspective dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        String id = this.getId(dockable);
        if (id != null) {
            this.dockables.put(id, dockable);
        }
    }

    public String[] getStationKeys() {
        return this.stations.keySet().toArray(new String[this.stations.size()]);
    }

    public CContentPerspective getContentArea() {
        return this.getContentArea("ccontrol");
    }

    public CContentPerspective getContentArea(String id) {
        return new CContentPerspective(this, id);
    }

    public CExternalizePerspective getScreenStation() {
        return (CExternalizePerspective)this.getStation("external");
    }

    public void shrink() {
        ArrayList<ShrinkablePerspectiveStation> elements = new ArrayList<ShrinkablePerspectiveStation>();
        Iterator<PerspectiveElement> iter = this.elements();
        while (iter.hasNext()) {
            PerspectiveElement next = iter.next();
            if (!(next instanceof ShrinkablePerspectiveStation)) continue;
            elements.add((ShrinkablePerspectiveStation)next);
        }
        for (ShrinkablePerspectiveStation station : elements) {
            station.shrink();
        }
    }

    public Iterator<PerspectiveElement> elements() {
        return new ElementIterator();
    }

    private class ElementIterator
    implements Iterator<PerspectiveElement> {
        private LinkedList<ElementFrame> stack = new LinkedList();

        public ElementIterator() {
            ArrayList<CommonElementPerspective> items = new ArrayList<CommonElementPerspective>();
            for (CStationPerspective station : CPerspective.this.stations.values()) {
                if (station.asDockable() != null && station.asDockable().getParent() != null) continue;
                items.add(station.intern());
            }
            this.stack.addFirst(new ElementFrame(items.toArray(new PerspectiveElement[items.size()])));
        }

        @Override
        public boolean hasNext() {
            for (ElementFrame frame : this.stack) {
                if (frame.offset >= frame.items.length) continue;
                return true;
            }
            return false;
        }

        @Override
        public PerspectiveElement next() {
            while (this.stack.size() > 0) {
                ElementFrame top = this.stack.peek();
                if (top.offset < top.items.length) {
                    PerspectiveElement result;
                    PerspectiveStation station;
                    if ((station = (result = top.items[top.offset++]).asStation()) != null) {
                        PerspectiveElement[] children = new PerspectiveElement[station.getDockableCount()];
                        for (int i = 0; i < children.length; ++i) {
                            children[i] = station.getDockable(i);
                        }
                        this.stack.addFirst(new ElementFrame(children));
                    }
                    return result;
                }
                this.stack.poll();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ElementFrame {
        public PerspectiveElement[] items;
        public int offset;

        public ElementFrame(PerspectiveElement[] items) {
            this.items = items;
        }
    }
}

