/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans;

import com.l2fprod.common.beans.DefaultBeanInfoResolver;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.UIManager;

public class BeanBinder {
    private final List<Object> bean = new ArrayList<Object>();
    private final PropertySheetPanel sheet;
    private final PropertyChangeListener listener;

    public BeanBinder(Object bean, PropertySheetPanel sheet) {
        this(new Object[]{bean}, sheet, new DefaultBeanInfoResolver().getBeanInfo(bean));
    }

    public BeanBinder(Object[] bean, PropertySheetPanel sheet) {
        this(bean, sheet, new DefaultBeanInfoResolver().getBeanInfo(bean));
    }

    public BeanBinder(Object[] bean, final PropertySheetPanel sheet, BeanInfo beanInfo) {
        this.bean.addAll(Arrays.asList(bean));
        this.sheet = sheet;
        for (Object bn : bean) {
            BeanInfo info = new DefaultBeanInfoResolver().getBeanInfo(bn);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                sheet.addProperty(pd);
            }
            sheet.readFromObject(bn);
        }
        final AtomicBoolean fire = new AtomicBoolean(true);
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (fire.get()) {
                    fire.set(false);
                    Property prop = (Property)evt.getSource();
                    for (Object bn : BeanBinder.this.bean) {
                        try {
                            prop.writeToObject(bn);
                            sheet.readFromObject(bn);
                        }
                        catch (RuntimeException e) {
                            if (!(e.getCause() instanceof PropertyVetoException)) continue;
                            UIManager.getLookAndFeel().provideErrorFeedback(BeanBinder.this.sheet);
                            prop.setValue(evt.getOldValue());
                        }
                    }
                }
                fire.set(true);
            }
        };
        sheet.addPropertySheetChangeListener(this.listener);
    }

    public void update() {
        for (Object bn : this.bean) {
            this.sheet.readFromObject(bn);
        }
    }

    public void unbind() {
        this.sheet.removePropertyChangeListener(this.listener);
        this.sheet.setProperties(new Property[0]);
    }
}

