/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.annotations.EditorRegistry;
import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.renderer.ColorCellRenderer;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

@EditorRegistry(type={Color.class})
public class ColorPropertyEditor
extends AbstractPropertyEditor {
    private final ColorCellRenderer label;
    private JButton button;
    private Color color;

    public ColorPropertyEditor() {
        this.editor = new JPanel(new PercentLayout(0, 0));
        this.label = new ColorCellRenderer();
        ((JPanel)this.editor).add("*", this.label);
        this.label.setOpaque(false);
        this.button = ComponentFactory.Helper.getFactory().createMiniButton();
        ((JPanel)this.editor).add(this.button);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPropertyEditor.this.selectColor();
            }
        });
        this.button = ComponentFactory.Helper.getFactory().createMiniButton();
        ((JPanel)this.editor).add(this.button);
        this.button.setText("X");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPropertyEditor.this.selectNull();
            }
        });
        ((JPanel)this.editor).setOpaque(false);
    }

    @Override
    public Object getValue() {
        return this.color;
    }

    @Override
    public void setValue(Object value) {
        this.color = (Color)value;
        this.label.setValue(this.color);
    }

    protected void selectColor() {
        ResourceManager rm = ResourceManager.all(FilePropertyEditor.class);
        String title = rm.getString("ColorPropertyEditor.title");
        Color selectedColor = JColorChooser.showDialog(this.editor, title, this.color);
        if (selectedColor != null) {
            Color oldColor = this.color;
            Color newColor = selectedColor;
            this.label.setValue(newColor);
            this.color = newColor;
            this.firePropertyChange(oldColor, newColor);
        }
    }

    protected void selectNull() {
        Color oldColor = this.color;
        this.label.setValue(null);
        this.color = null;
        this.firePropertyChange(oldColor, null);
    }

    public static class AsInt
    extends ColorPropertyEditor {
        @Override
        public void setValue(Object arg0) {
            if (arg0 instanceof Integer) {
                super.setValue(new Color((Integer)arg0));
            } else {
                super.setValue(arg0);
            }
        }

        @Override
        public Object getValue() {
            Object value = super.getValue();
            if (value == null) {
                return null;
            }
            return ((Color)value).getRGB();
        }

        @Override
        protected void firePropertyChange(Object oldValue, Object newValue) {
            if (oldValue instanceof Color) {
                oldValue = ((Color)oldValue).getRGB();
            }
            if (newValue instanceof Color) {
                newValue = ((Color)newValue).getRGB();
            }
            super.firePropertyChange(oldValue, newValue);
        }
    }
}

